/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.tiny.server.http;

import com.sun.net.httpserver.HttpExchange;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Pattern;
import net.morimekta.tiny.server.http.TinyHttpHandler;
import net.morimekta.tiny.server.http.TinyHttpUtil;

public final class TinyPrometheusHttpHandler
extends TinyHttpHandler {
    private final CollectorRegistry registry;

    public TinyPrometheusHttpHandler() {
        this(CollectorRegistry.defaultRegistry);
    }

    public TinyPrometheusHttpHandler(CollectorRegistry registry) {
        this.registry = registry;
    }

    @Override
    protected void doGet(HttpExchange exchange) throws IOException {
        Pattern filter;
        Map<String, String> query = TinyHttpUtil.parseQuery(exchange.getRequestURI().getQuery());
        if (query.containsKey("filter")) {
            try {
                filter = Pattern.compile(query.get("filter"));
            }
            catch (Exception e) {
                exchange.sendResponseHeaders(400, 0L);
                exchange.getResponseBody().close();
                return;
            }
        } else {
            filter = null;
        }
        exchange.getResponseHeaders().set("Content-Type", "text/plain; charset=UTF-8");
        exchange.sendResponseHeaders(200, 0L);
        try (OutputStream os = exchange.getResponseBody();
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));){
            if (filter != null) {
                TextFormat.write004((Writer)writer, (Enumeration)this.registry.filteredMetricFamilySamples(str -> filter.matcher((CharSequence)str).matches()));
            } else {
                TextFormat.write004((Writer)writer, (Enumeration)this.registry.metricFamilySamples());
            }
        }
    }
}

