/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.tiny.server.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public abstract class TinyHttpHandler
implements HttpHandler {
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        block24: {
            try {
                exchange.getResponseHeaders().set("Date", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
                exchange.getResponseHeaders().set("Server", "tiny-server");
                switch (exchange.getRequestMethod()) {
                    case "GET": {
                        this.doGet(exchange);
                        break;
                    }
                    case "POST": {
                        this.doPost(exchange);
                        break;
                    }
                    case "HEAD": {
                        this.doHead(exchange);
                        break;
                    }
                    case "OPTIONS": {
                        this.doOptions(exchange);
                        break;
                    }
                    case "CONNECT": {
                        this.toConnect(exchange);
                        break;
                    }
                    case "TRACE": {
                        this.doTrace(exchange);
                        break;
                    }
                    case "PUT": {
                        this.doPut(exchange);
                        break;
                    }
                    case "PATCH": {
                        this.doPatch(exchange);
                        break;
                    }
                    case "DELETE": {
                        this.doDelete(exchange);
                        break;
                    }
                    default: {
                        exchange.sendResponseHeaders(400, 0L);
                        exchange.close();
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (exchange.getResponseCode() > 0) break block24;
                exchange.sendResponseHeaders(500, 0L);
                exchange.getResponseBody().close();
            }
        }
    }

    protected void doGet(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(405, 0L);
    }

    protected void doPost(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(405, 0L);
    }

    protected void doHead(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(405, 0L);
    }

    protected void doOptions(HttpExchange exchange) throws IOException {
        exchange.getResponseHeaders().set("Allow", "OPTIONS, GET, POST");
        exchange.sendResponseHeaders(204, 0L);
    }

    protected void toConnect(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(405, 0L);
    }

    protected void doTrace(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(405, 0L);
    }

    protected void doPut(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(405, 0L);
    }

    protected void doPatch(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(405, 0L);
    }

    protected void doDelete(HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(405, 0L);
    }
}

