/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.tiny.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.morimekta.file.FileUtil;
import net.morimekta.tiny.server.config.ConfigReader;

public class ConfigSupplier<ConfigType>
implements Supplier<ConfigType> {
    private final AtomicReference<ConfigType> reference = new AtomicReference();
    private final ConfigReader<ConfigType> loader;

    public ConfigSupplier(ConfigReader<ConfigType> loader) {
        this.loader = loader;
    }

    public void loadUnchecked(Path filePath) {
        try {
            this.load(filePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    public void load(Path filePath) throws IOException {
        Path canonical = FileUtil.readCanonicalPath((Path)filePath);
        if (!Files.exists(canonical, new LinkOption[0])) {
            throw new FileNotFoundException("No such config file " + filePath);
        }
        if (!Files.isRegularFile(canonical, new LinkOption[0])) {
            throw new IOException("Config path " + filePath + " is not a regular file.");
        }
        this.reference.set(Objects.requireNonNull(this.loader.readConfig(filePath), "loaded config == null"));
    }

    @Override
    public ConfigType get() {
        return Optional.of(this.reference.get()).orElseThrow(() -> new NullPointerException("Config not loaded."));
    }

    public static <ConfigType> ConfigSupplier<ConfigType> yamlConfig(Class<ConfigType> type) {
        return ConfigSupplier.yamlConfig(type, mapper -> {});
    }

    public static <ConfigType> ConfigSupplier<ConfigType> yamlConfig(Class<ConfigType> type, Consumer<ObjectMapper> initMapper) {
        return new ConfigSupplier<ConfigType>(new ConfigReader.YamlConfigReader<ConfigType>(type, initMapper));
    }
}

