/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.tiny.server.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import net.morimekta.file.FileUtil;

public abstract class ConfigReader<ConfigType> {
    protected ConfigReader() {
    }

    public ConfigType readConfig(Path file) throws IOException {
        Path canonical = FileUtil.readCanonicalPath((Path)file);
        if (!Files.exists(canonical, new LinkOption[0])) {
            throw new FileNotFoundException("No such config file " + file);
        }
        if (!Files.isRegularFile(canonical, new LinkOption[0])) {
            throw new IOException("Config path " + file + " is not a regular file.");
        }
        try (InputStream in = Files.newInputStream(canonical, StandardOpenOption.READ);){
            ConfigType ConfigType = this.parseConfig(file.getFileName().toString(), in);
            return ConfigType;
        }
    }

    protected abstract ConfigType parseConfig(String var1, InputStream var2) throws IOException;

    public static class YamlConfigReader<ConfigType>
    extends ConfigReader<ConfigType> {
        private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        private final Class<ConfigType> configType;

        public YamlConfigReader(Class<ConfigType> configType, Consumer<ObjectMapper> init) {
            this.configType = configType;
            init.accept(this.mapper);
        }

        @Override
        protected ConfigType parseConfig(String fileName, InputStream stream) throws IOException {
            return (ConfigType)this.mapper.readValue(stream, this.configType);
        }
    }
}

