/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.tiny.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import io.prometheus.client.CollectorRegistry;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.morimekta.tiny.server.TinyApplication;
import net.morimekta.tiny.server.http.TinyHealth;
import net.morimekta.tiny.server.http.TinyHealthHttpHandler;
import net.morimekta.tiny.server.http.TinyHttpHandler;
import net.morimekta.tiny.server.http.TinyPrometheusHttpHandler;
import net.morimekta.tiny.server.http.TinyReadyHttpHandler;

public final class TinyApplicationContext {
    static final String SERVER_READINESS = "tiny-server";
    private final int localPort;
    private final HttpServer httpServer;
    private final Map<String, TinyHealth.ReadyCheck> readyCheckMap;
    private final Map<String, TinyHealth.HealthCheck> healthCheckMap;

    private TinyApplicationContext(HttpServer httpServer, Map<String, TinyHealth.ReadyCheck> readyCheckMap, Map<String, TinyHealth.HealthCheck> healthCheckMap) {
        this.httpServer = httpServer;
        this.localPort = httpServer.getAddress().getPort();
        this.readyCheckMap = readyCheckMap;
        this.healthCheckMap = healthCheckMap;
    }

    public int getAdminPort() {
        return this.localPort;
    }

    public TinyApplicationContext addReadyCheck(String name, TinyHealth.ReadyCheck readyCheck) {
        if (this.readyCheckMap.containsKey(name)) {
            throw new IllegalArgumentException("Ready check with name \"" + name + "\" already exists.");
        }
        this.readyCheckMap.put(name, readyCheck);
        return this;
    }

    public TinyApplicationContext removeReadyCheck(String name) {
        this.readyCheckMap.remove(name);
        return this;
    }

    public TinyApplicationContext addHealthCheck(String name, TinyHealth.HealthCheck healthCheck) {
        if (this.healthCheckMap.containsKey(name)) {
            throw new IllegalArgumentException("Health check with name \"" + name + "\" already exists.");
        }
        this.healthCheckMap.put(name, healthCheck);
        return this;
    }

    public TinyApplicationContext removeHealthCheck(String name) {
        this.healthCheckMap.remove(name);
        return this;
    }

    void stopServer() {
        this.httpServer.stop(0);
    }

    void setReady() {
        this.removeReadyCheck(SERVER_READINESS);
    }

    void setStopping() {
        this.addReadyCheck(SERVER_READINESS, () -> new TinyHealth.Result(TinyHealth.Status.UNHEALTHY, "Server is stopping."));
    }

    public static final class Builder {
        private final TinyApplication server;
        private int localPort = 0;
        private String localHost = "0.0.0.0";
        private CollectorRegistry registry = CollectorRegistry.defaultRegistry;
        private int threads = 10;

        public Builder(TinyApplication server) {
            this.server = server;
        }

        public void setCollectorRegistry(CollectorRegistry registry) {
            this.registry = registry;
        }

        void setLocalPort(int localPort) {
            this.localPort = localPort;
        }

        void setLocalHost(String localHost) {
            this.localHost = localHost;
        }

        void setAdminServerThreads(int threads) {
            this.threads = threads;
        }

        TinyApplicationContext build() throws IOException {
            ConcurrentHashMap<String, TinyHealth.HealthCheck> healthChecks = new ConcurrentHashMap<String, TinyHealth.HealthCheck>();
            ConcurrentHashMap<String, TinyHealth.ReadyCheck> readyChecks = new ConcurrentHashMap<String, TinyHealth.ReadyCheck>();
            readyChecks.put(TinyApplicationContext.SERVER_READINESS, () -> new TinyHealth.Result(TinyHealth.Status.UNHEALTHY, "Server is starting."));
            HttpServer httpServer = HttpServer.create(new InetSocketAddress(this.localHost, this.localPort), 100);
            httpServer.setExecutor(Executors.newFixedThreadPool(this.threads, new ThreadFactory(){
                final AtomicInteger nextId = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setName("TinyHttpServer-" + this.nextId.getAndIncrement());
                    thread.setDaemon(true);
                    return thread;
                }
            }));
            httpServer.createContext("/ready", new TinyReadyHttpHandler(readyChecks));
            httpServer.createContext("/healthy", new TinyHealthHttpHandler(healthChecks));
            httpServer.createContext("/metrics", new TinyPrometheusHttpHandler(this.registry));
            httpServer.createContext("/drain", new TinyHttpHandler(){

                @Override
                protected void doGet(HttpExchange exchange) throws IOException {
                    Thread thread = new Thread(server::stop);
                    thread.setName("TinyServerDrain");
                    thread.setDaemon(false);
                    thread.start();
                    exchange.sendResponseHeaders(204, -1L);
                }
            });
            httpServer.start();
            return new TinyApplicationContext(httpServer, readyChecks, healthChecks);
        }
    }
}

