/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.thrift.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nonnull;
import org.apache.thrift.transport.TFramedTransport;

public class FramedBufferOutputStream
extends OutputStream {
    private static final int MAX_BUFFER_SIZE = 0xFA0000;
    private final byte[] frameSizeBuffer;
    private final ByteBuffer buffer;
    private final WritableByteChannel out;

    public FramedBufferOutputStream(WritableByteChannel out) {
        this(out, 0xFA0000);
    }

    public FramedBufferOutputStream(WritableByteChannel out, int maxBufferSize) {
        this.out = out;
        this.frameSizeBuffer = new byte[4];
        this.buffer = ByteBuffer.allocateDirect(maxBufferSize);
        this.buffer.limit(maxBufferSize);
    }

    @Override
    public void write(int val) throws IOException {
        if (!this.buffer.hasRemaining()) {
            throw new IOException(String.format("Frame size exceeded: 1 needed, 0 remaining, %d total", this.buffer.capacity()));
        }
        this.buffer.put((byte)val);
    }

    @Override
    public void write(@Nonnull byte[] bytes) throws IOException {
        if (this.buffer.remaining() < bytes.length) {
            throw new IOException(String.format("Frame size exceeded: %d needed, %d remaining, %d total", bytes.length, this.buffer.remaining(), this.buffer.capacity()));
        }
        this.buffer.put(bytes);
    }

    @Override
    public void write(@Nonnull byte[] var1, int off, int len) throws IOException {
        if (this.buffer.remaining() < len) {
            throw new IOException(String.format("Frame size exceeded: %d needed, %d remaining, %d total", len, this.buffer.remaining(), this.buffer.capacity()));
        }
        this.buffer.put(var1, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeFrame() throws IOException {
        int frameSize = this.buffer.position();
        if (frameSize > 0) {
            TFramedTransport.encodeFrameSize((int)frameSize, (byte[])this.frameSizeBuffer);
            this.buffer.flip();
            WritableByteChannel writableByteChannel = this.out;
            synchronized (writableByteChannel) {
                this.out.write(ByteBuffer.wrap(this.frameSizeBuffer));
                while (this.buffer.hasRemaining()) {
                    this.out.write(this.buffer);
                }
            }
            this.buffer.rewind();
            this.buffer.limit(this.buffer.capacity());
        }
    }

    @Override
    public void close() throws IOException {
        this.completeFrame();
    }
}

