/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.thrift.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.annotation.Nonnull;
import org.apache.thrift.transport.TFramedTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FramedBufferInputStream
extends InputStream {
    private static Logger LOGGER = LoggerFactory.getLogger((String)FramedBufferInputStream.class.getName());
    private static final int MAX_BUFFER_SIZE = 0xFA0000;
    private final ByteBuffer frameSizeBuffer;
    private final ReadableByteChannel in;
    private final ByteBuffer buffer;

    public FramedBufferInputStream(ReadableByteChannel in) {
        this(in, 0xFA0000);
    }

    public FramedBufferInputStream(ReadableByteChannel in, int maxFrameSize) {
        this.in = in;
        this.frameSizeBuffer = ByteBuffer.allocate(4);
        this.buffer = ByteBuffer.allocateDirect(maxFrameSize);
        this.buffer.limit(0);
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.limit() == 0 && this.readFrame() < 0) {
            return -1;
        }
        return FramedBufferInputStream.intValue(this.buffer.get());
    }

    private static int intValue(byte b) {
        if (b < 0) {
            return b + 256;
        }
        return b;
    }

    @Override
    public int read(@Nonnull byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    @Override
    public int read(@Nonnull byte[] data, int off, int len) throws IOException {
        int pos;
        int readLen;
        if (off < 0 || len < 0) {
            throw new IOException();
        }
        if (off + len > data.length) {
            throw new IOException();
        }
        for (pos = 0; pos < len; pos += readLen) {
            if (this.buffer.limit() == 0 && this.readFrame() < 0) {
                return pos;
            }
            if (this.buffer.remaining() == 0) {
                return pos;
            }
            int remaining = this.buffer.remaining();
            readLen = Math.min(len - pos, remaining);
            this.buffer.get(data, off + pos, readLen);
        }
        return pos;
    }

    public void nextFrame() {
        this.buffer.rewind();
        this.buffer.limit(0);
    }

    private int readFrame() throws IOException {
        this.frameSizeBuffer.rewind();
        this.in.read(this.frameSizeBuffer);
        if (this.frameSizeBuffer.position() == 0) {
            return -1;
        }
        if (this.frameSizeBuffer.position() < 4) {
            throw new IOException();
        }
        int frameSize = TFramedTransport.decodeFrameSize((byte[])this.frameSizeBuffer.array());
        if (frameSize < 1) {
            throw new IOException("Invalid frame size " + frameSize);
        }
        if (frameSize > this.buffer.capacity()) {
            IOException ex = new IOException("Frame size too large " + frameSize + " > " + this.buffer.capacity());
            try {
                while (frameSize > 0) {
                    this.buffer.rewind();
                    this.buffer.limit(Math.max(frameSize, this.buffer.capacity()));
                    int r = this.in.read(this.buffer);
                    if (r > 0) {
                        frameSize -= r;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                ex.addSuppressed(e);
            }
            throw ex;
        }
        this.buffer.rewind();
        this.buffer.limit(frameSize);
        while (this.in.read(this.buffer) > 0 && this.buffer.position() != frameSize) {
            LOGGER.debug("still not enough:  " + this.buffer.position() + " of " + frameSize);
        }
        if (this.buffer.position() < frameSize) {
            throw new IOException();
        }
        this.buffer.flip();
        return frameSize;
    }
}

