/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.Binary;
import net.morimekta.util.io.CountingOutputStream;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TTupleProtocolSerializer
extends Serializer {
    public static final String MIME_TYPE = "application/vnd.apache.thrift.tuple";
    private final boolean readStrict;
    private final TProtocolFactory protocolFactory;

    public TTupleProtocolSerializer() {
        this(true);
    }

    public TTupleProtocolSerializer(boolean readStrict) {
        this.readStrict = readStrict;
        this.protocolFactory = new TTupleProtocol.Factory();
    }

    public <Message extends PMessage<Message, Field>, Field extends PField> int serialize(OutputStream output, Message message) throws IOException {
        CountingOutputStream wrapper = new CountingOutputStream(output);
        TIOStreamTransport transport = new TIOStreamTransport((OutputStream)wrapper);
        try {
            TTupleProtocol protocol = (TTupleProtocol)this.protocolFactory.getProtocol((TTransport)transport);
            this.writeMessage(message, protocol);
            transport.flush();
            wrapper.flush();
            return wrapper.getByteCount();
        }
        catch (TException e) {
            throw new SerializerException((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    public <Message extends PMessage<Message, Field>, Field extends PField> int serialize(OutputStream output, PServiceCall<Message, Field> call) throws IOException {
        CountingOutputStream wrapper = new CountingOutputStream(output);
        TIOStreamTransport transport = new TIOStreamTransport((OutputStream)wrapper);
        try {
            TTupleProtocol protocol = (TTupleProtocol)this.protocolFactory.getProtocol((TTransport)transport);
            TMessage tm = new TMessage(call.getMethod(), (byte)call.getType().getValue(), call.getSequence());
            protocol.writeMessageBegin(tm);
            this.writeMessage(call.getMessage(), protocol);
            protocol.writeMessageEnd();
            transport.flush();
            wrapper.flush();
            return wrapper.getByteCount();
        }
        catch (TException e) {
            throw new SerializerException((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    public <Message extends PMessage<Message, Field>, Field extends PField> Message deserialize(InputStream input, PMessageDescriptor<Message, Field> descriptor) throws IOException {
        try {
            TIOStreamTransport transport = new TIOStreamTransport(input);
            TTupleProtocol protocol = (TTupleProtocol)this.protocolFactory.getProtocol((TTransport)transport);
            return this.readMessage(protocol, descriptor);
        }
        catch (TTransportException e) {
            throw new SerializerException((Throwable)e, "Unable to serialize into transport protocol", new Object[0]);
        }
        catch (TException e) {
            throw new SerializerException((Throwable)e, "Transport exception in protocol", new Object[0]);
        }
    }

    public <Message extends PMessage<Message, Field>, Field extends PField> PServiceCall<Message, Field> deserialize(InputStream input, PService service) throws SerializerException {
        TMessage tm = null;
        PServiceCallType type = null;
        try {
            TIOStreamTransport transport = new TIOStreamTransport(input);
            TTupleProtocol protocol = (TTupleProtocol)this.protocolFactory.getProtocol((TTransport)transport);
            tm = protocol.readMessageBegin();
            type = PServiceCallType.forValue((int)tm.type);
            if (type == null) {
                throw new SerializerException("Unknown call type for id " + tm.type, new Object[0]);
            }
            if (type == PServiceCallType.EXCEPTION) {
                PApplicationException exception = (PApplicationException)this.readMessage(protocol, (PMessageDescriptor<Message, Field>)PApplicationException.kDescriptor);
                return new PServiceCall(tm.name, type, tm.seqid, (PMessage)exception);
            }
            PServiceMethod method = service.getMethod(tm.name);
            if (method == null) {
                throw new SerializerException("No such method " + tm.name + " on " + service.getQualifiedName(), new Object[0]);
            }
            PStructDescriptor descriptor = this.isRequestCallType(type) ? method.getRequestType() : method.getResponseType();
            Message message = this.readMessage(protocol, (PMessageDescriptor<Message, Field>)descriptor);
            protocol.readMessageEnd();
            return new PServiceCall(tm.name, type, tm.seqid, message);
        }
        catch (TTransportException e) {
            throw new SerializerException((Throwable)e, "Unable to serialize into transport protocol", new Object[0]).setExceptionType(PApplicationExceptionType.forValue((int)e.getType())).setCallType(type).setMethodName(tm != null ? tm.name : "").setSequenceNo(tm != null ? tm.seqid : 0);
        }
        catch (TException e) {
            throw new SerializerException((Throwable)e, "Transport exception in protocol", new Object[0]).setExceptionType(PApplicationExceptionType.PROTOCOL_ERROR).setCallType(type).setMethodName(tm != null ? tm.name : "").setSequenceNo(tm != null ? tm.seqid : 0);
        }
    }

    public boolean binaryProtocol() {
        return true;
    }

    public String mimeType() {
        return MIME_TYPE;
    }

    private void writeMessage(PMessage<?, ?> message, TTupleProtocol protocol) throws TException, SerializerException {
        PMessageDescriptor descriptor = message.descriptor();
        if (descriptor.getVariant() == PMessageVariant.UNION) {
            PField fld = ((PUnion)message).unionField();
            protocol.writeI16((short)fld.getKey());
            this.writeTypedValue(message.get(fld.getKey()), fld.getDescriptor(), protocol);
        } else {
            PField[] fields = descriptor.getFields();
            Arrays.sort(fields, (a, b) -> Integer.compare(a.getKey(), b.getKey()));
            int numOptionals = this.countOptionals(fields);
            BitSet optionals = new BitSet();
            if (numOptionals > 0) {
                int optionalPos = 0;
                for (PField fld : fields) {
                    if (fld.getRequirement() == PRequirement.REQUIRED) continue;
                    if (message.has(fld.getKey())) {
                        optionals.set(optionalPos);
                    }
                    ++optionalPos;
                }
            }
            boolean shouldWriteOptionals = true;
            int optionalPos = 0;
            for (PField fld : fields) {
                if (fld.getRequirement() == PRequirement.REQUIRED) {
                    this.writeTypedValue(message.get(fld.getKey()), fld.getDescriptor(), protocol);
                    continue;
                }
                if (shouldWriteOptionals) {
                    protocol.writeBitSet(optionals, numOptionals);
                    shouldWriteOptionals = false;
                }
                if (optionals.get(optionalPos)) {
                    this.writeTypedValue(message.get(fld.getKey()), fld.getDescriptor(), protocol);
                }
                ++optionalPos;
            }
        }
    }

    private int countOptionals(PField[] fields) {
        int numOptionals = 0;
        for (PField fld : fields) {
            if (fld.getRequirement() == PRequirement.REQUIRED) continue;
            ++numOptionals;
        }
        return numOptionals;
    }

    private <Message extends PMessage<Message, Field>, Field extends PField> Message readMessage(TTupleProtocol protocol, PMessageDescriptor<Message, Field> descriptor) throws SerializerException, TException {
        PMessageBuilder builder = descriptor.builder();
        if (descriptor.getVariant() == PMessageVariant.UNION) {
            short fieldId = protocol.readI16();
            PField fld = descriptor.getField((int)fieldId);
            builder.set(fld.getKey(), this.readTypedValue(fld.getDescriptor(), protocol));
        } else {
            PField[] fields = descriptor.getFields();
            int numOptionals = this.countOptionals(fields);
            BitSet optionals = null;
            int optionalPos = 0;
            for (PField fld : fields) {
                if (fld.getRequirement() == PRequirement.REQUIRED) {
                    builder.set(fld.getKey(), this.readTypedValue(fld.getDescriptor(), protocol));
                    continue;
                }
                if (optionals == null) {
                    optionals = protocol.readBitSet(numOptionals);
                }
                if (optionals.get(optionalPos)) {
                    builder.set(fld.getKey(), this.readTypedValue(fld.getDescriptor(), protocol));
                }
                ++optionalPos;
            }
        }
        if (this.readStrict) {
            try {
                builder.validate();
            }
            catch (IllegalStateException e) {
                throw new SerializerException((Throwable)e, e.getMessage(), new Object[0]);
            }
        }
        return (Message)((PMessage)builder.build());
    }

    private Object readTypedValue(PDescriptor type, TTupleProtocol protocol) throws TException, SerializerException {
        switch (type.getType()) {
            case BOOL: {
                return protocol.readBool();
            }
            case BYTE: {
                return protocol.readByte();
            }
            case I16: {
                return protocol.readI16();
            }
            case I32: {
                return protocol.readI32();
            }
            case I64: {
                return protocol.readI64();
            }
            case DOUBLE: {
                return protocol.readDouble();
            }
            case BINARY: {
                ByteBuffer buffer = protocol.readBinary();
                return Binary.wrap((byte[])buffer.array());
            }
            case STRING: {
                return protocol.readString();
            }
            case ENUM: {
                PEnumDescriptor et = (PEnumDescriptor)type;
                PEnumBuilder eb = et.builder();
                int value = protocol.readI32();
                eb.setByValue(value);
                if (this.readStrict && !eb.valid()) {
                    throw new SerializerException("Invalid enum value " + value + " for " + et.getQualifiedName(), new Object[0]);
                }
                return eb.build();
            }
            case MESSAGE: {
                return this.readMessage(protocol, (PMessageDescriptor)type);
            }
            case LIST: {
                int lSize = protocol.readI32();
                PList lDesc = (PList)type;
                PDescriptor liDesc = lDesc.itemDescriptor();
                PList.Builder list = lDesc.builder();
                for (int i = 0; i < lSize; ++i) {
                    list.add(this.readTypedValue(liDesc, protocol));
                }
                return list.build();
            }
            case SET: {
                int sSize = protocol.readI32();
                PSet sDesc = (PSet)type;
                PDescriptor siDesc = sDesc.itemDescriptor();
                PSet.Builder set = sDesc.builder();
                for (int i = 0; i < sSize; ++i) {
                    set.add(this.readTypedValue(siDesc, protocol));
                }
                return set.build();
            }
            case MAP: {
                int mSize = protocol.readI32();
                PMap mDesc = (PMap)type;
                PDescriptor mkDesc = mDesc.keyDescriptor();
                PDescriptor miDesc = mDesc.itemDescriptor();
                PMap.Builder map = mDesc.builder();
                for (int i = 0; i < mSize; ++i) {
                    Object key = this.readTypedValue(mkDesc, protocol);
                    Object val = this.readTypedValue(miDesc, protocol);
                    map.put(key, val);
                }
                protocol.readMapEnd();
                return map.build();
            }
        }
        throw new SerializerException("Unsupported protocol field type: " + type.getType(), new Object[0]);
    }

    private void writeTypedValue(Object item, PDescriptor type, TTupleProtocol protocol) throws TException, SerializerException {
        switch (type.getType()) {
            case BOOL: {
                protocol.writeBool(((Boolean)item).booleanValue());
                break;
            }
            case BYTE: {
                protocol.writeByte(((Byte)item).byteValue());
                break;
            }
            case I16: {
                protocol.writeI16(((Short)item).shortValue());
                break;
            }
            case I32: {
                protocol.writeI32(((Integer)item).intValue());
                break;
            }
            case I64: {
                protocol.writeI64(((Long)item).longValue());
                break;
            }
            case DOUBLE: {
                protocol.writeDouble(((Double)item).doubleValue());
                break;
            }
            case STRING: {
                protocol.writeString((String)item);
                break;
            }
            case BINARY: {
                protocol.writeBinary(((Binary)item).getByteBuffer());
                break;
            }
            case ENUM: {
                PEnumValue value = (PEnumValue)item;
                protocol.writeI32(value.getValue());
                break;
            }
            case MESSAGE: {
                this.writeMessage((PMessage)item, protocol);
                break;
            }
            case LIST: {
                PList lType = (PList)type;
                List list = (List)item;
                protocol.writeI32(list.size());
                for (Object i : list) {
                    this.writeTypedValue(i, lType.itemDescriptor(), protocol);
                }
                break;
            }
            case SET: {
                PSet sType = (PSet)type;
                Set set = (Set)item;
                protocol.writeI32(set.size());
                for (Object i : set) {
                    this.writeTypedValue(i, sType.itemDescriptor(), protocol);
                }
                break;
            }
            case MAP: {
                PMap mType = (PMap)type;
                Map map = (Map)item;
                protocol.writeI32(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    this.writeTypedValue(entry.getKey(), mType.keyDescriptor(), protocol);
                    this.writeTypedValue(entry.getValue(), mType.itemDescriptor(), protocol);
                }
                protocol.writeMapEnd();
                break;
            }
        }
    }
}

