/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.thrift.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallHandler;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.serializer.Serializer;

public class SocketClientHandler
implements PServiceCallHandler {
    private final Serializer serializer;
    private final SocketAddress address;
    private final int connect_timeout;
    private final int read_timeout;

    public SocketClientHandler(Serializer serializer, SocketAddress address) {
        this(serializer, address, 10000, 10000);
    }

    public SocketClientHandler(Serializer serializer, SocketAddress address, int connect_timeout, int read_timeout) {
        this.serializer = serializer;
        this.address = address;
        this.connect_timeout = connect_timeout;
        this.read_timeout = read_timeout;
    }

    private synchronized Socket connect() throws IOException {
        Socket socket = new Socket();
        socket.setSoLinger(false, 0);
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        socket.setSoTimeout(this.read_timeout);
        socket.connect(this.address, this.connect_timeout);
        return socket;
    }

    public <Request extends PMessage<Request, RequestField>, Response extends PMessage<Response, ResponseField>, RequestField extends PField, ResponseField extends PField> PServiceCall<Response, ResponseField> handleCall(PServiceCall<Request, RequestField> call, PService service) throws IOException {
        if (call.getType() == PServiceCallType.EXCEPTION || call.getType() == PServiceCallType.REPLY) {
            throw new PApplicationException("Request with invalid call type: " + call.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
        }
        try (Socket socket = this.connect();){
            BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
            this.serializer.serialize((OutputStream)out, call);
            ((OutputStream)out).flush();
            PServiceCall reply = null;
            if (call.getType() == PServiceCallType.CALL) {
                BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
                reply = this.serializer.deserialize((InputStream)in, service);
                if (reply.getType() == PServiceCallType.CALL || reply.getType() == PServiceCallType.ONEWAY) {
                    throw new PApplicationException("Reply with invalid call type: " + reply.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                }
                if (reply.getSequence() != call.getSequence()) {
                    throw new PApplicationException("Reply sequence out of order: call = " + call.getSequence() + ", reply = " + reply.getSequence(), PApplicationExceptionType.BAD_SEQUENCE_ID);
                }
            }
            PServiceCall pServiceCall = reply;
            return pServiceCall;
        }
    }
}

