/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.thrift;

import net.morimekta.providence.serializer.DefaultSerializerProvider;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerProvider;
import net.morimekta.providence.thrift.TBinaryProtocolSerializer;
import net.morimekta.providence.thrift.TCompactProtocolSerializer;
import net.morimekta.providence.thrift.TJsonProtocolSerializer;
import net.morimekta.providence.thrift.TSimpleJsonProtocolSerializer;

public class ThriftSerializerProvider
extends DefaultSerializerProvider {
    private final SerializerProvider baseProvider;

    public ThriftSerializerProvider() {
        this((SerializerProvider)new DefaultSerializerProvider(){});
    }

    public ThriftSerializerProvider(SerializerProvider base) {
        if (base instanceof ThriftSerializerProvider) {
            throw new IllegalArgumentException();
        }
        this.baseProvider = base;
    }

    public Serializer getSerializer(String contentType) {
        switch (contentType) {
            case "application/vnd.apache.thrift.binary": 
            case "application/x-thrift": {
                return new TBinaryProtocolSerializer();
            }
            case "application/vnd.apache.thrift.compact": {
                return new TCompactProtocolSerializer();
            }
            case "application/vnd.apache.thrift.json": {
                return new TJsonProtocolSerializer();
            }
            case "application/json": {
                return new TSimpleJsonProtocolSerializer();
            }
        }
        return this.baseProvider.getSerializer(contentType);
    }
}

