/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.thrift.client;

import java.util.HashMap;
import java.util.Map;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerProvider;
import net.morimekta.providence.thrift.TCompactProtocolSerializer;
import net.morimekta.providence.thrift.TJsonProtocolSerializer;
import net.morimekta.providence.thrift.TSimpleJsonProtocolSerializer;
import net.morimekta.providence.thrift.TTupleProtocolSerializer;

public class ThriftOnlySerializerProvider
implements SerializerProvider {
    private final Map<String, Serializer> serializerMap;
    private final String defaultContentType;

    public ThriftOnlySerializerProvider() {
        this("application/vnd.apache.thrift.binary");
    }

    public ThriftOnlySerializerProvider(String defaultContentType) {
        this.defaultContentType = defaultContentType;
        this.serializerMap = new HashMap<String, Serializer>();
        this.register((Serializer)new BinarySerializer(), "application/vnd.apache.thrift.binary", "application/x-thrift");
        this.register(new TCompactProtocolSerializer(), "application/vnd.apache.thrift.compact");
        this.register(new TJsonProtocolSerializer(), "application/vnd.apache.thrift.json");
        this.register(new TTupleProtocolSerializer(), "application/vnd.apache.thrift.tuple");
        this.register(new TSimpleJsonProtocolSerializer(), "application/json");
    }

    public Serializer getSerializer(String mimeType) {
        return this.serializerMap.get(mimeType);
    }

    public Serializer getDefault() {
        return this.getSerializer(this.defaultContentType);
    }

    protected void register(Serializer serializer, String ... mimeTypes) {
        for (String mimeType : mimeTypes) {
            this.serializerMap.put(mimeType, serializer);
        }
    }
}

