/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.ApplicationException;
import net.morimekta.providence.serializer.ApplicationExceptionType;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.Binary;
import net.morimekta.util.io.CountingOutputStream;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

class TProtocolSerializer
extends Serializer {
    private final TProtocolFactory protocolFactory;
    private final boolean readStrict;
    private final boolean binary;
    private final String mimeType;

    public TProtocolSerializer(boolean readStrict, TProtocolFactory protocolFactory, boolean binary, String mimeType) {
        this.readStrict = readStrict;
        this.protocolFactory = protocolFactory;
        this.binary = binary;
        this.mimeType = mimeType;
    }

    public boolean binaryProtocol() {
        return this.binary;
    }

    public String mimeType() {
        return this.mimeType;
    }

    public <Message extends PMessage<Message, Field>, Field extends PField> int serialize(OutputStream output, Message message) throws IOException, SerializerException {
        CountingOutputStream wrapper = new CountingOutputStream(output);
        TIOStreamTransport transport = new TIOStreamTransport((OutputStream)wrapper);
        try {
            TProtocol protocol = this.protocolFactory.getProtocol((TTransport)transport);
            this.writeMessage(message, protocol);
            transport.flush();
            wrapper.flush();
            return wrapper.getByteCount();
        }
        catch (TException e) {
            throw new SerializerException((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    public <Message extends PMessage<Message, Field>, Field extends PField> int serialize(OutputStream output, PServiceCall<Message, Field> call) throws IOException, SerializerException {
        CountingOutputStream wrapper = new CountingOutputStream(output);
        TIOStreamTransport transport = new TIOStreamTransport((OutputStream)wrapper);
        try {
            TProtocol protocol = this.protocolFactory.getProtocol((TTransport)transport);
            TMessage tm = new TMessage(call.getMethod(), (byte)call.getType().key, call.getSequence());
            protocol.writeMessageBegin(tm);
            this.writeMessage(call.getMessage(), protocol);
            protocol.writeMessageEnd();
            transport.flush();
            wrapper.flush();
            return wrapper.getByteCount();
        }
        catch (TException e) {
            throw new SerializerException((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    public <Message extends PMessage<Message, Field>, Field extends PField> Message deserialize(InputStream input, PStructDescriptor<Message, Field> descriptor) throws IOException, SerializerException {
        try {
            TIOStreamTransport transport = new TIOStreamTransport(input);
            TProtocol protocol = this.protocolFactory.getProtocol((TTransport)transport);
            return this.readMessage(protocol, descriptor);
        }
        catch (TTransportException e) {
            throw new SerializerException((Throwable)e, "Unable to serialize into transport protocol", new Object[0]);
        }
        catch (TException e) {
            throw new SerializerException((Throwable)e, "Transport exception in protocol", new Object[0]);
        }
    }

    public <Message extends PMessage<Message, Field>, Field extends PField> PServiceCall<Message, Field> deserialize(InputStream input, PService service) throws SerializerException {
        PServiceCallType type = null;
        TMessage tm = null;
        try {
            TIOStreamTransport transport = new TIOStreamTransport(input);
            TProtocol protocol = this.protocolFactory.getProtocol((TTransport)transport);
            tm = protocol.readMessageBegin();
            type = PServiceCallType.findByKey((int)tm.type);
            if (type == null) {
                throw new SerializerException("Unknown call type for id " + tm.type, new Object[0]);
            }
            if (type == PServiceCallType.EXCEPTION) {
                ApplicationException exception = (ApplicationException)this.readMessage(protocol, (PStructDescriptor<Message, Field>)ApplicationException.kDescriptor);
                return new PServiceCall(tm.name, type, tm.seqid, (PMessage)exception);
            }
            PServiceMethod method = service.getMethod(tm.name);
            if (method == null) {
                throw new SerializerException("No such method " + tm.name + " on " + service.getQualifiedName(null), new Object[0]);
            }
            PStructDescriptor descriptor = type.request ? method.getRequestType() : method.getResponseType();
            Message message = this.readMessage(protocol, descriptor);
            protocol.readMessageEnd();
            return new PServiceCall(tm.name, type, tm.seqid, message);
        }
        catch (TTransportException e) {
            throw new SerializerException((Throwable)e, e.getMessage(), new Object[0]).setExceptionType(ApplicationExceptionType.forValue((int)e.getType())).setCallType(type).setSequenceNo(tm != null ? tm.seqid : 0).setMethodName(tm != null ? tm.name : null);
        }
        catch (TException e) {
            throw new SerializerException((Throwable)e, e.getMessage(), new Object[0]).setExceptionType(ApplicationExceptionType.PROTOCOL_ERROR).setCallType(type).setSequenceNo(tm != null ? tm.seqid : 0).setMethodName(tm != null ? tm.name : null);
        }
    }

    private void writeMessage(PMessage<?, ?> message, TProtocol protocol) throws TException, SerializerException {
        PStructDescriptor type = message.descriptor();
        protocol.writeStructBegin(new TStruct(message.descriptor().getQualifiedName(null)));
        for (PField field : type.getFields()) {
            if (!message.has(field.getKey())) continue;
            protocol.writeFieldBegin(new TField(field.getName(), this.getFieldType(field.getDescriptor()), (short)field.getKey()));
            this.writeTypedValue(message.get(field.getKey()), field.getDescriptor(), protocol);
            protocol.writeFieldEnd();
        }
        protocol.writeFieldStop();
        protocol.writeStructEnd();
    }

    private <Message extends PMessage<Message, Field>, Field extends PField> Message readMessage(TProtocol protocol, PStructDescriptor<Message, Field> descriptor) throws SerializerException, TException {
        TField f;
        PMessageBuilder builder = descriptor.builder();
        protocol.readStructBegin();
        while ((f = protocol.readFieldBegin()) != null && f.type != PType.STOP.id) {
            PField field;
            if (f.id != 0) {
                field = descriptor.getField((int)f.id);
                if (field == null) {
                    throw new SerializerException("No such field " + f.id + " in " + descriptor.getQualifiedName(null), new Object[0]);
                }
            } else {
                field = descriptor.getField(f.name);
                if (field == null) {
                    throw new SerializerException("No such field " + f.name + " in " + descriptor.getQualifiedName(null), new Object[0]);
                }
            }
            if (f.type != this.getFieldType(field.getDescriptor())) {
                throw new SerializerException("Incompatible serialized type " + PType.findById((byte)f.type) + " for field " + field.getName() + ", expected " + field.getDescriptor().getType(), new Object[0]);
            }
            Object value = this.readTypedValue(f.type, field.getDescriptor(), protocol);
            if (value == null) {
                throw new SerializerException("Illegal null field value", new Object[0]);
            }
            builder.set(field.getKey(), value);
            protocol.readFieldEnd();
        }
        protocol.readStructEnd();
        if (this.readStrict) {
            try {
                builder.validate();
            }
            catch (IllegalStateException e) {
                throw new SerializerException((Throwable)e, e.getMessage(), new Object[0]);
            }
        }
        return (Message)((PMessage)builder.build());
    }

    private <T> T readTypedValue(byte tType, PDescriptor type, TProtocol protocol) throws TException, SerializerException {
        switch (tType) {
            case 2: {
                return (T)this.cast(protocol.readBool());
            }
            case 3: {
                return (T)this.cast(protocol.readByte());
            }
            case 6: {
                return (T)this.cast(protocol.readI16());
            }
            case 8: {
                if (PType.ENUM == type.getType()) {
                    PEnumDescriptor et = (PEnumDescriptor)type;
                    PEnumBuilder eb = et.builder();
                    int value = protocol.readI32();
                    eb.setByValue(value);
                    if (!eb.isValid() && this.readStrict) {
                        throw new SerializerException("Invalid enum value " + value + " for " + et.getQualifiedName(null), new Object[0]);
                    }
                    return (T)this.cast(eb.build());
                }
                return (T)this.cast(protocol.readI32());
            }
            case 10: {
                return (T)this.cast(protocol.readI64());
            }
            case 4: {
                return (T)this.cast(protocol.readDouble());
            }
            case 11: {
                if (type == PPrimitive.BINARY) {
                    ByteBuffer buffer = protocol.readBinary();
                    return (T)this.cast(Binary.wrap((byte[])buffer.array()));
                }
                return (T)this.cast(protocol.readString());
            }
            case 12: {
                return (T)this.cast(this.readMessage(protocol, (PStructDescriptor)type));
            }
            case 15: {
                TList listInfo = protocol.readListBegin();
                PList lDesc = (PList)type;
                PDescriptor liDesc = lDesc.itemDescriptor();
                PList.Builder list = lDesc.builder();
                for (int i = 0; i < listInfo.size; ++i) {
                    list.add(this.readTypedValue(listInfo.elemType, liDesc, protocol));
                }
                protocol.readListEnd();
                return (T)this.cast(list.build());
            }
            case 14: {
                TSet setInfo = protocol.readSetBegin();
                PSet sDesc = (PSet)type;
                PDescriptor siDesc = sDesc.itemDescriptor();
                PSet.Builder set = sDesc.builder();
                for (int i = 0; i < setInfo.size; ++i) {
                    set.add(this.cast(this.readTypedValue(setInfo.elemType, siDesc, protocol)));
                }
                protocol.readSetEnd();
                return (T)this.cast(set.build());
            }
            case 13: {
                TMap mapInfo = protocol.readMapBegin();
                PMap mDesc = (PMap)type;
                PDescriptor mkDesc = mDesc.keyDescriptor();
                PDescriptor miDesc = mDesc.itemDescriptor();
                PMap.Builder map = mDesc.builder();
                for (int i = 0; i < mapInfo.size; ++i) {
                    T key = this.readTypedValue(mapInfo.keyType, mkDesc, protocol);
                    T val = this.readTypedValue(mapInfo.valueType, miDesc, protocol);
                    map.put(key, val);
                }
                protocol.readMapEnd();
                return (T)this.cast(map.build());
            }
        }
        throw new SerializerException("Unsupported protocol field type: " + tType, new Object[0]);
    }

    private void writeTypedValue(Object item, PDescriptor type, TProtocol protocol) throws TException, SerializerException {
        switch (type.getType()) {
            case BOOL: {
                protocol.writeBool(((Boolean)item).booleanValue());
                break;
            }
            case BYTE: {
                protocol.writeByte(((Byte)item).byteValue());
                break;
            }
            case I16: {
                protocol.writeI16(((Short)item).shortValue());
                break;
            }
            case I32: {
                protocol.writeI32(((Integer)item).intValue());
                break;
            }
            case I64: {
                protocol.writeI64(((Long)item).longValue());
                break;
            }
            case DOUBLE: {
                protocol.writeDouble(((Double)item).doubleValue());
                break;
            }
            case STRING: {
                protocol.writeString((String)item);
                break;
            }
            case BINARY: {
                protocol.writeBinary(((Binary)item).getByteBuffer());
                break;
            }
            case ENUM: {
                PEnumValue value = (PEnumValue)item;
                protocol.writeI32(value.getValue());
                break;
            }
            case MESSAGE: {
                this.writeMessage((PMessage)item, protocol);
                break;
            }
            case LIST: {
                PList lType = (PList)type;
                List list = (List)item;
                TList listInfo = new TList(this.getFieldType(lType.itemDescriptor()), list.size());
                protocol.writeListBegin(listInfo);
                for (Object i : list) {
                    this.writeTypedValue(i, lType.itemDescriptor(), protocol);
                }
                protocol.writeListEnd();
                break;
            }
            case SET: {
                PSet sType = (PSet)type;
                Set set = (Set)item;
                TSet setInfo = new TSet(this.getFieldType(sType.itemDescriptor()), set.size());
                protocol.writeSetBegin(setInfo);
                for (Object i : set) {
                    this.writeTypedValue(i, sType.itemDescriptor(), protocol);
                }
                protocol.writeSetEnd();
                break;
            }
            case MAP: {
                PMap mType = (PMap)type;
                Map map = (Map)item;
                protocol.writeMapBegin(new TMap(this.getFieldType(mType.keyDescriptor()), this.getFieldType(mType.itemDescriptor()), map.size()));
                for (Map.Entry entry : map.entrySet()) {
                    this.writeTypedValue(entry.getKey(), mType.keyDescriptor(), protocol);
                    this.writeTypedValue(entry.getValue(), mType.itemDescriptor(), protocol);
                }
                protocol.writeMapEnd();
            }
        }
    }

    private byte getFieldType(PDescriptor type) throws SerializerException {
        if (type == null) {
            throw new SerializerException("No type!", new Object[0]);
        }
        return type.getType().id;
    }
}

