/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.thrift.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import net.morimekta.providence.PClientHandler;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;

public class SocketClientHandler
implements PClientHandler {
    private final Serializer serializer;
    private final SocketAddress address;

    public SocketClientHandler(Serializer serializer, SocketAddress address) {
        this.serializer = serializer;
        this.address = address;
    }

    private synchronized Socket connect() throws IOException {
        Socket socket = new Socket();
        socket.setSoLinger(false, 0);
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        socket.connect(this.address, 100);
        return socket;
    }

    public <RQ extends PMessage<RQ>, RS extends PMessage<RS>> PServiceCall<RS> handleCall(PServiceCall<RQ> call, PService service) throws IOException, SerializerException {
        try (Socket socket = this.connect();){
            BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
            this.serializer.serialize((OutputStream)out, call);
            ((OutputStream)out).flush();
            if (call.getType() != PServiceCallType.ONEWAY) {
                BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
                PServiceCall pServiceCall = this.serializer.deserialize((InputStream)in, service);
                return pServiceCall;
            }
            PServiceCall<RS> pServiceCall = null;
            return pServiceCall;
        }
    }
}

