/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.thrift;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.thrift.TProtocolSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class TCompactProtocolSerializer
extends TProtocolSerializer {
    public static final String MEDIA_TYPE = "application/vnd.apache.thrift.compact";

    public TCompactProtocolSerializer() {
        this(false);
    }

    public TCompactProtocolSerializer(boolean readStrict) {
        super(readStrict, (TProtocolFactory)new TCompactProtocol.Factory(), true, MEDIA_TYPE);
    }

    public void verifyEndOfContent(@Nonnull InputStream input) throws IOException {
        try {
            int in = input.read();
            if (in >= 0) {
                throw new SerializerException("More content after end: 0x%02x", new Object[]{in}).setExceptionType(PApplicationExceptionType.PROTOCOL_ERROR);
            }
        }
        finally {
            input.close();
        }
    }
}

