/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.util.Binary;
import net.morimekta.util.io.CountingOutputStream;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

abstract class TProtocolSerializer
extends Serializer {
    private final TProtocolFactory protocolFactory;
    private final boolean readStrict;
    private final boolean binary;
    private final String mediaType;

    public TProtocolSerializer(boolean readStrict, TProtocolFactory protocolFactory, boolean binary, String mediaType) {
        this.readStrict = readStrict;
        this.protocolFactory = protocolFactory;
        this.binary = binary;
        this.mediaType = mediaType;
    }

    public boolean binaryProtocol() {
        return this.binary;
    }

    @Nonnull
    public String mediaType() {
        return this.mediaType;
    }

    public <Message extends PMessage<Message>> int serialize(@Nonnull OutputStream output, @Nonnull PMessageOrBuilder<Message> message) throws IOException {
        CountingOutputStream wrapper = new CountingOutputStream(output);
        TIOStreamTransport transport = new TIOStreamTransport((OutputStream)wrapper);
        try {
            TProtocol protocol = this.protocolFactory.getProtocol((TTransport)transport);
            this.writeMessage(message, protocol);
            transport.flush();
            wrapper.flush();
            return wrapper.getByteCount();
        }
        catch (TException e) {
            throw new SerializerException((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    public <Message extends PMessage<Message>> int serialize(@Nonnull OutputStream output, @Nonnull PServiceCall<Message> call) throws IOException {
        CountingOutputStream wrapper = new CountingOutputStream(output);
        TIOStreamTransport transport = new TIOStreamTransport((OutputStream)wrapper);
        try {
            TProtocol protocol = this.protocolFactory.getProtocol((TTransport)transport);
            TMessage tm = new TMessage(call.getMethod(), (byte)call.getType().asInteger(), call.getSequence());
            protocol.writeMessageBegin(tm);
            this.writeMessage((PMessageOrBuilder<?>)call.getMessage(), protocol);
            protocol.writeMessageEnd();
            transport.flush();
            wrapper.flush();
            return wrapper.getByteCount();
        }
        catch (TException e) {
            throw new SerializerException((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    @Nonnull
    public <Message extends PMessage<Message>> Message deserialize(@Nonnull InputStream input, @Nonnull PMessageDescriptor<Message> descriptor) throws IOException {
        try {
            TIOStreamTransport transport = new TIOStreamTransport(input);
            TProtocol protocol = this.protocolFactory.getProtocol((TTransport)transport);
            return this.readMessage(protocol, descriptor);
        }
        catch (TTransportException e) {
            throw new SerializerException((Throwable)e, "Unable to serialize into transport protocol", new Object[0]);
        }
        catch (TException e) {
            throw new SerializerException((Throwable)e, "Transport exception in protocol", new Object[0]);
        }
    }

    @Nonnull
    public <Message extends PMessage<Message>> PServiceCall<Message> deserialize(@Nonnull InputStream input, @Nonnull PService service) throws SerializerException {
        PServiceCallType type = null;
        TMessage tm = null;
        try {
            TIOStreamTransport transport = new TIOStreamTransport(input);
            TProtocol protocol = this.protocolFactory.getProtocol((TTransport)transport);
            tm = protocol.readMessageBegin();
            type = PServiceCallType.findById((Integer)Integer.valueOf(tm.type));
            if (type == null) {
                throw new SerializerException("Unknown call type for id " + tm.type, new Object[0]).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
            }
            if (type == PServiceCallType.EXCEPTION) {
                PApplicationException exception = (PApplicationException)this.readMessage(protocol, (PMessageDescriptor<Message>)PApplicationException.kDescriptor);
                return new PServiceCall(tm.name, type, tm.seqid, (PMessage)exception);
            }
            PServiceMethod method = service.getMethod(tm.name);
            if (method == null) {
                throw new SerializerException("No such method " + tm.name + " on " + service.getQualifiedName(), new Object[0]).setExceptionType(PApplicationExceptionType.UNKNOWN_METHOD);
            }
            PStructDescriptor descriptor = this.isRequestCallType(type) ? method.getRequestType() : method.getResponseType();
            Message message = this.readMessage(protocol, (PMessageDescriptor<Message>)descriptor);
            protocol.readMessageEnd();
            return new PServiceCall(tm.name, type, tm.seqid, message);
        }
        catch (TTransportException e) {
            throw new SerializerException((Throwable)e, e.getMessage(), new Object[0]).setExceptionType(PApplicationExceptionType.findById((Integer)e.getType())).setCallType(type).setSequenceNo(tm != null ? tm.seqid : 0).setMethodName(tm != null ? tm.name : null);
        }
        catch (TException e) {
            throw new SerializerException((Throwable)e, e.getMessage(), new Object[0]).setExceptionType(PApplicationExceptionType.PROTOCOL_ERROR).setCallType(type).setSequenceNo(tm != null ? tm.seqid : 0).setMethodName(tm != null ? tm.name : null);
        }
        catch (SerializerException e) {
            e.setMethodName(tm.name).setSequenceNo(tm.seqid).setCallType(type);
            throw e;
        }
    }

    private void writeMessage(PMessageOrBuilder<?> message, TProtocol protocol) throws TException, SerializerException {
        PMessageDescriptor type = message.descriptor();
        protocol.writeStructBegin(new TStruct(message.descriptor().getQualifiedName()));
        for (PField field : type.getFields()) {
            if (!message.has(field.getId())) continue;
            protocol.writeFieldBegin(new TField(field.getName(), BinaryType.forType((PType)field.getDescriptor().getType()), (short)field.getId()));
            this.writeTypedValue(message.get(field.getId()), field.getDescriptor(), protocol);
            protocol.writeFieldEnd();
        }
        protocol.writeFieldStop();
        protocol.writeStructEnd();
    }

    private <Message extends PMessage<Message>> Message readMessage(TProtocol protocol, PMessageDescriptor<Message> descriptor) throws SerializerException, TException {
        TField f;
        PMessageBuilder builder = descriptor.builder();
        protocol.readStructBegin();
        while ((f = protocol.readFieldBegin()) != null && f.type != 0) {
            PField field = descriptor.findFieldById((int)f.id);
            if (field != null) {
                if (f.type != BinaryType.forType((PType)field.getDescriptor().getType())) {
                    throw new SerializerException("Incompatible serialized type " + BinaryType.asString((byte)f.type) + " for field " + field.getName() + ", expected " + BinaryType.asString((byte)BinaryType.forType((PType)field.getDescriptor().getType())), new Object[0]);
                }
                Object value = this.readTypedValue(f.type, field.getDescriptor(), protocol, true);
                if (value != null) {
                    builder.set(field.getId(), value);
                }
            } else {
                TProtocolUtil.skip((TProtocol)protocol, (byte)f.type);
            }
            protocol.readFieldEnd();
        }
        protocol.readStructEnd();
        if (this.readStrict) {
            try {
                builder.validate();
            }
            catch (IllegalStateException e) {
                throw new SerializerException((Throwable)e, e.getMessage(), new Object[0]);
            }
        }
        return (Message)((PMessage)builder.build());
    }

    private Object readTypedValue(byte tType, PDescriptor type, TProtocol protocol, boolean allowNull) throws TException, SerializerException {
        if (tType != BinaryType.forType((PType)type.getType())) {
            throw new SerializerException("Expected type " + BinaryType.asString((byte)BinaryType.forType((PType)type.getType())) + " but found " + BinaryType.asString((byte)tType), new Object[0]);
        }
        switch (tType) {
            case 2: {
                return protocol.readBool();
            }
            case 3: {
                return protocol.readByte();
            }
            case 6: {
                return protocol.readI16();
            }
            case 8: {
                if (PType.ENUM == type.getType()) {
                    PEnumDescriptor et = (PEnumDescriptor)type;
                    PEnumBuilder eb = et.builder();
                    int value = protocol.readI32();
                    eb.setById(value);
                    if (!eb.valid() && !allowNull) {
                        throw new SerializerException("Invalid enum value " + value + " for " + et.getQualifiedName(), new Object[0]);
                    }
                    return eb.build();
                }
                return protocol.readI32();
            }
            case 10: {
                return protocol.readI64();
            }
            case 4: {
                return protocol.readDouble();
            }
            case 11: {
                if (type == PPrimitive.BINARY) {
                    ByteBuffer buffer = protocol.readBinary();
                    return Binary.wrap((byte[])buffer.array());
                }
                return protocol.readString();
            }
            case 12: {
                return this.readMessage(protocol, (PMessageDescriptor)type);
            }
            case 15: {
                TList listInfo = protocol.readListBegin();
                PList lDesc = (PList)type;
                PDescriptor liDesc = lDesc.itemDescriptor();
                PList.Builder list = lDesc.builder(listInfo.size);
                for (int i = 0; i < listInfo.size; ++i) {
                    list.add(this.readTypedValue(listInfo.elemType, liDesc, protocol, false));
                }
                protocol.readListEnd();
                return list.build();
            }
            case 14: {
                TSet setInfo = protocol.readSetBegin();
                PSet sDesc = (PSet)type;
                PDescriptor siDesc = sDesc.itemDescriptor();
                PSet.Builder set = sDesc.builder(setInfo.size);
                for (int i = 0; i < setInfo.size; ++i) {
                    set.add(this.readTypedValue(setInfo.elemType, siDesc, protocol, false));
                }
                protocol.readSetEnd();
                return set.build();
            }
            case 13: {
                TMap mapInfo = protocol.readMapBegin();
                PMap mDesc = (PMap)type;
                PDescriptor mkDesc = mDesc.keyDescriptor();
                PDescriptor miDesc = mDesc.itemDescriptor();
                PMap.Builder map = mDesc.builder(mapInfo.size);
                for (int i = 0; i < mapInfo.size; ++i) {
                    Object key = this.readTypedValue(mapInfo.keyType, mkDesc, protocol, false);
                    Object val = this.readTypedValue(mapInfo.valueType, miDesc, protocol, false);
                    map.put(key, val);
                }
                protocol.readMapEnd();
                return map.build();
            }
        }
        throw new SerializerException("Unsupported protocol field type: " + tType, new Object[0]);
    }

    private void writeTypedValue(Object item, PDescriptor type, TProtocol protocol) throws TException, SerializerException {
        switch (type.getType()) {
            case BOOL: {
                protocol.writeBool(((Boolean)item).booleanValue());
                break;
            }
            case BYTE: {
                protocol.writeByte(((Byte)item).byteValue());
                break;
            }
            case I16: {
                protocol.writeI16(((Short)item).shortValue());
                break;
            }
            case I32: {
                protocol.writeI32(((Integer)item).intValue());
                break;
            }
            case I64: {
                protocol.writeI64(((Long)item).longValue());
                break;
            }
            case DOUBLE: {
                protocol.writeDouble(((Double)item).doubleValue());
                break;
            }
            case STRING: {
                protocol.writeString((String)item);
                break;
            }
            case BINARY: {
                protocol.writeBinary(((Binary)item).getByteBuffer());
                break;
            }
            case ENUM: {
                PEnumValue value = (PEnumValue)item;
                protocol.writeI32(value.asInteger());
                break;
            }
            case MESSAGE: {
                this.writeMessage((PMessageOrBuilder<?>)((PMessage)item), protocol);
                break;
            }
            case LIST: {
                PList lType = (PList)type;
                List list = (List)item;
                TList listInfo = new TList(BinaryType.forType((PType)lType.itemDescriptor().getType()), list.size());
                protocol.writeListBegin(listInfo);
                for (Object i : list) {
                    this.writeTypedValue(i, lType.itemDescriptor(), protocol);
                }
                protocol.writeListEnd();
                break;
            }
            case SET: {
                PSet sType = (PSet)type;
                Set set = (Set)item;
                TSet setInfo = new TSet(BinaryType.forType((PType)sType.itemDescriptor().getType()), set.size());
                protocol.writeSetBegin(setInfo);
                for (Object i : set) {
                    this.writeTypedValue(i, sType.itemDescriptor(), protocol);
                }
                protocol.writeSetEnd();
                break;
            }
            case MAP: {
                PMap mType = (PMap)type;
                Map map = (Map)item;
                protocol.writeMapBegin(new TMap(BinaryType.forType((PType)mType.keyDescriptor().getType()), BinaryType.forType((PType)mType.itemDescriptor().getType()), map.size()));
                for (Map.Entry entry : map.entrySet()) {
                    this.writeTypedValue(entry.getKey(), mType.keyDescriptor(), protocol);
                    this.writeTypedValue(entry.getValue(), mType.itemDescriptor(), protocol);
                }
                protocol.writeMapEnd();
                break;
            }
        }
    }
}

