/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.thrift.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallHandler;
import net.morimekta.providence.PServiceCallInstrumentation;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.thrift.io.FramedBufferInputStream;
import net.morimekta.providence.thrift.io.FramedBufferOutputStream;
import net.morimekta.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonblockingSocketClientHandler
implements PServiceCallHandler,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonblockingSocketClientHandler.class);
    private final Serializer serializer;
    private final SocketAddress address;
    private final int connect_timeout;
    private final int read_timeout;
    private final int response_timeout;
    private final Map<Integer, CompletableFuture<PServiceCall>> responseFutures;
    private final ExecutorService executorService;
    private final PServiceCallInstrumentation instrumentation;
    private final BlockingQueue<PServiceCall> requestQueue;
    private final PService service;
    private volatile SocketChannel channel;
    private volatile FramedBufferOutputStream out;

    public NonblockingSocketClientHandler(Serializer serializer, SocketAddress address, PService service) {
        this(serializer, address, service, PServiceCallInstrumentation.NOOP);
    }

    public NonblockingSocketClientHandler(Serializer serializer, SocketAddress address, PService service, PServiceCallInstrumentation instrumentation) {
        this(serializer, address, service, instrumentation, 10000, 10000);
    }

    public NonblockingSocketClientHandler(Serializer serializer, SocketAddress address, PService service, int connect_timeout, int read_timeout) {
        this(serializer, address, service, PServiceCallInstrumentation.NOOP, connect_timeout, read_timeout);
    }

    public NonblockingSocketClientHandler(Serializer serializer, SocketAddress address, PService service, PServiceCallInstrumentation instrumentation, int connect_timeout, int read_timeout) {
        this(serializer, address, service, instrumentation, connect_timeout, read_timeout, connect_timeout + 2 * read_timeout);
    }

    public NonblockingSocketClientHandler(Serializer serializer, SocketAddress address, PService service, PServiceCallInstrumentation instrumentation, int connect_timeout, int read_timeout, int response_timeout) {
        this.serializer = serializer;
        this.address = address;
        this.service = service;
        this.instrumentation = instrumentation;
        this.connect_timeout = connect_timeout;
        this.read_timeout = read_timeout;
        this.response_timeout = response_timeout;
        this.responseFutures = new ConcurrentHashMap<Integer, CompletableFuture<PServiceCall>>();
        this.requestQueue = new LinkedBlockingQueue<PServiceCall>();
        this.executorService = Executors.newFixedThreadPool(2, (ThreadFactory)NamedThreadFactory.builder().setDaemon(true).setNameFormat("non-blocking-%d").build());
        this.executorService.submit(this::handleWriteRequests);
    }

    @Override
    public synchronized void close() throws IOException {
        this.executorService.shutdown();
        if (this.channel != null) {
            try (SocketChannel ignore = this.channel;
                 FramedBufferOutputStream ignore2 = this.out;){
                this.channel = null;
                this.out = null;
            }
        }
        try {
            this.executorService.shutdownNow();
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <Request extends PMessage<Request>, Response extends PMessage<Response>> PServiceCall<Response> handleCall(PServiceCall<Request> call, PService service) throws IOException {
        if (call.getType() == PServiceCallType.EXCEPTION) throw new PApplicationException("Request with invalid call type: " + call.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
        if (call.getType() == PServiceCallType.REPLY) {
            throw new PApplicationException("Request with invalid call type: " + call.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
        }
        long startTime = System.nanoTime();
        PServiceCall response = null;
        CompletableFuture responseFuture = null;
        responseFuture = new CompletableFuture();
        this.responseFutures.put(call.getSequence(), responseFuture);
        try {
            this.requestQueue.put(call);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            try {
                response = this.response_timeout > 0 ? (PServiceCall)responseFuture.get(this.response_timeout, TimeUnit.MILLISECONDS) : (PServiceCall)responseFuture.get();
                long endTime = System.nanoTime();
                double duration = (double)(endTime - startTime) / (double)PServiceCallInstrumentation.NS_IN_MILLIS;
                try {
                    this.instrumentation.onComplete(duration, call, response);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PServiceCall pServiceCall = response;
                return pServiceCall;
            }
            catch (InterruptedException | TimeoutException e) {
                responseFuture.completeExceptionally(e);
                throw new IOException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof IOException)) throw new IOException(e.getMessage(), e);
                e.getCause().addSuppressed(e);
                throw (IOException)e.getCause();
            }
            finally {
                this.responseFutures.remove(call.getSequence());
            }
        }
        catch (Exception e) {
            long endTime = System.nanoTime();
            double duration = (double)(endTime - startTime) / (double)PServiceCallInstrumentation.NS_IN_MILLIS;
            try {
                this.instrumentation.onTransportException(e, duration, call, response);
                throw e;
            }
            catch (Exception ie) {
                e.addSuppressed(ie);
            }
            throw e;
        }
    }

    private synchronized FramedBufferOutputStream ensureConnected() throws IOException {
        if (this.channel == null || !this.channel.isConnected()) {
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(true);
            Socket socket = this.channel.socket();
            socket.setSoLinger(false, 0);
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            socket.setSoTimeout(this.read_timeout);
            socket.connect(this.address, this.connect_timeout);
            this.out = new FramedBufferOutputStream(this.channel);
            this.executorService.submit(() -> this.handleReadResponses(this.channel));
        }
        return this.out;
    }

    private void handleWriteRequests() {
        while (!this.executorService.isShutdown()) {
            try {
                CompletableFuture<PServiceCall> future;
                PServiceCall call = this.requestQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (call == null) continue;
                try {
                    FramedBufferOutputStream out = this.ensureConnected();
                    try {
                        this.serializer.serialize((OutputStream)out, call);
                        out.flush();
                    }
                    finally {
                        out.completeFrame();
                    }
                    if (call.getType() != PServiceCallType.ONEWAY || (future = this.responseFutures.remove(call.getSequence())) == null) continue;
                    future.complete(null);
                }
                catch (IOException e) {
                    try {
                        this.close();
                    }
                    catch (IOException e2) {
                        e.addSuppressed(e2);
                    }
                    if ((future = this.responseFutures.remove(call.getSequence())) == null) continue;
                    this.responseFutures.remove(call.getSequence());
                    future.completeExceptionally(e);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private void handleReadResponses(SocketChannel channel) {
        FramedBufferInputStream in = new FramedBufferInputStream(channel);
        while (this.channel == channel && channel.isOpen()) {
            try {
                in.nextFrame();
                PServiceCall reply = this.serializer.deserialize((InputStream)in, this.service);
                if (reply.getType() == PServiceCallType.CALL || reply.getType() == PServiceCallType.ONEWAY) {
                    throw new PApplicationException("Reply with invalid call type: " + reply.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                }
                CompletableFuture<PServiceCall> future = this.responseFutures.remove(reply.getSequence());
                if (future == null) {
                    LOGGER.debug("No future for sequence ID " + reply.getSequence());
                    continue;
                }
                future.complete(reply);
            }
            catch (Exception e) {
                if (this.channel != channel || !channel.isOpen()) break;
                LOGGER.error("Exception in channel response reading", (Throwable)e);
            }
        }
        if (this.responseFutures.size() > 0) {
            LOGGER.warn("Channel closed with {} unfinished calls", (Object)this.responseFutures.size());
            this.responseFutures.forEach((s, f) -> f.completeExceptionally(new IOException("Channel closed")));
            this.responseFutures.clear();
        }
    }
}

