/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.thrift.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallHandler;
import net.morimekta.providence.PServiceCallInstrumentation;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.thrift.io.FramedBufferInputStream;
import net.morimekta.providence.thrift.io.FramedBufferOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonblockingSocketClientHandler
implements PServiceCallHandler,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonblockingSocketClientHandler.class);
    private final Serializer serializer;
    private final SocketAddress address;
    private final int connect_timeout;
    private final int read_timeout;
    private final int response_timeout;
    private final Map<Integer, CompletableFuture<PServiceCall>> responseFutures;
    private final ExecutorService responseExecutor;
    private final PServiceCallInstrumentation instrumentation;
    private volatile SocketChannel channel;
    private volatile FramedBufferOutputStream out;

    public NonblockingSocketClientHandler(Serializer serializer, SocketAddress address) {
        this(serializer, address, (d, c, r) -> {});
    }

    public NonblockingSocketClientHandler(Serializer serializer, SocketAddress address, PServiceCallInstrumentation instrumentation) {
        this(serializer, address, instrumentation, 10000, 10000);
    }

    public NonblockingSocketClientHandler(Serializer serializer, SocketAddress address, int connect_timeout, int read_timeout) {
        this(serializer, address, (d, c, r) -> {}, connect_timeout, read_timeout);
    }

    public NonblockingSocketClientHandler(Serializer serializer, SocketAddress address, PServiceCallInstrumentation instrumentation, int connect_timeout, int read_timeout) {
        this(serializer, address, instrumentation, connect_timeout, read_timeout, connect_timeout + 2 * read_timeout);
    }

    public NonblockingSocketClientHandler(Serializer serializer, SocketAddress address, PServiceCallInstrumentation instrumentation, int connect_timeout, int read_timeout, int response_timeout) {
        this.serializer = serializer;
        this.address = address;
        this.instrumentation = instrumentation;
        this.connect_timeout = connect_timeout;
        this.read_timeout = read_timeout;
        this.response_timeout = response_timeout;
        this.responseFutures = new ConcurrentHashMap<Integer, CompletableFuture<PServiceCall>>();
        this.responseExecutor = Executors.newSingleThreadExecutor();
    }

    private void ensureConnected(PService service) throws IOException {
        if (this.channel == null || !this.channel.isConnected()) {
            this.close();
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(true);
            Socket socket = this.channel.socket();
            socket.setSoLinger(false, 0);
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            socket.setSoTimeout(this.read_timeout);
            socket.connect(this.address, this.connect_timeout);
            this.out = new FramedBufferOutputStream(this.channel);
            this.responseExecutor.submit(() -> this.handleReadResponses(this.channel, service));
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.channel != null) {
            try (SocketChannel ignore1 = this.channel;
                 FramedBufferOutputStream ignore2 = this.out;){
                this.channel = null;
                this.out = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <Request extends PMessage<Request>, Response extends PMessage<Response>> PServiceCall<Response> handleCall(PServiceCall<Request> call, PService service) throws IOException {
        if (call.getType() == PServiceCallType.EXCEPTION) throw new PApplicationException("Request with invalid call type: " + call.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
        if (call.getType() == PServiceCallType.REPLY) {
            throw new PApplicationException("Request with invalid call type: " + call.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
        }
        long startTime = System.nanoTime();
        PServiceCall response = null;
        CompletableFuture responseFuture = null;
        if (call.getType() == PServiceCallType.CALL) {
            responseFuture = new CompletableFuture();
            this.responseFutures.put(call.getSequence(), responseFuture);
        }
        try {
            NonblockingSocketClientHandler nonblockingSocketClientHandler = this;
            synchronized (nonblockingSocketClientHandler) {
                try {
                    this.ensureConnected(service);
                    if (this.out == null) {
                        throw new IOException("Closed channel");
                    }
                    this.serializer.serialize((OutputStream)this.out, call);
                    this.out.flush();
                }
                finally {
                    if (this.out != null) {
                        this.out.completeFrame();
                    }
                }
            }
            if (responseFuture == null) return null;
            try {
                response = this.response_timeout > 0 ? (PServiceCall)responseFuture.get(this.response_timeout, TimeUnit.MILLISECONDS) : (PServiceCall)responseFuture.get();
                long endTime = System.nanoTime();
                double duration = (double)(endTime - startTime) / (double)PServiceCallInstrumentation.NS_IN_MILLIS;
                try {
                    this.instrumentation.onComplete(duration, call, response);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PServiceCall pServiceCall = response;
                return pServiceCall;
            }
            catch (InterruptedException | TimeoutException e) {
                responseFuture.completeExceptionally(e);
                throw new IOException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                this.responseFutures.remove(call.getSequence());
            }
        }
        catch (Exception e) {
            long endTime = System.nanoTime();
            double duration = (double)(endTime - startTime) / (double)PServiceCallInstrumentation.NS_IN_MILLIS;
            try {
                this.instrumentation.onTransportException(e, duration, call, response);
                throw e;
            }
            catch (Exception ie) {
                e.addSuppressed(ie);
            }
            throw e;
        }
    }

    private void handleReadResponses(SocketChannel channel, PService service) {
        while (this.channel == channel && channel.isOpen()) {
            FramedBufferInputStream in = new FramedBufferInputStream(channel);
            try {
                in.nextFrame();
                PServiceCall reply = this.serializer.deserialize((InputStream)in, service);
                if (reply.getType() == PServiceCallType.CALL || reply.getType() == PServiceCallType.ONEWAY) {
                    throw new PApplicationException("Reply with invalid call type: " + reply.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                }
                CompletableFuture<PServiceCall> future = this.responseFutures.get(reply.getSequence());
                if (future == null) {
                    LOGGER.debug("No future for sequence ID " + reply.getSequence());
                    continue;
                }
                this.responseFutures.remove(reply.getSequence());
                future.complete(reply);
            }
            catch (Exception e) {
                if (!channel.isOpen()) break;
                LOGGER.error("Exception in channel response reading", (Throwable)e);
            }
        }
        if (this.responseFutures.size() > 0) {
            LOGGER.warn("Channel closed with {} unfinished calls", (Object)this.responseFutures.size());
            this.responseFutures.forEach((s, f) -> f.completeExceptionally(new IOException("Channel closed")));
            this.responseFutures.clear();
        }
    }
}

