/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.morimekta.util.ExtraStreams;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.UnmodifiableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnglishWords {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnglishWords.class);
    private static final List<String> nouns;
    private static final List<String> adjectives;
    private static final List<String> verbs;
    private static final Random random;

    @Nonnull
    public static String noun() {
        return nouns.get(random.nextInt(nouns.size()));
    }

    @Nonnull
    public static String thing() {
        if (random.nextBoolean()) {
            return EnglishWords.adjective() + " " + EnglishWords.noun();
        }
        return EnglishWords.noun();
    }

    @Nonnull
    public static String adjective() {
        return adjectives.get(random.nextInt(adjectives.size()));
    }

    @Nonnull
    public static String verb() {
        return verbs.get(random.nextInt(verbs.size()));
    }

    @Nonnull
    public static String sentence(int minLength) {
        StringBuilder sentence = new StringBuilder();
        while (sentence.length() < minLength) {
            if (sentence.length() > 0) {
                sentence.append(", and ").append(EnglishWords.thing());
            } else {
                sentence.append(Strings.capitalize((String)EnglishWords.thing()));
            }
            sentence.append(" ").append(EnglishWords.verb()).append(" ").append(EnglishWords.thing());
        }
        return sentence.toString();
    }

    @Nonnull
    public static String paragraph(int sentences) {
        return ExtraStreams.times((int)sentences).sequential().map(i -> random.nextInt(50) + 20).mapToObj(EnglishWords::sentence).collect(Collectors.joining(". ")) + ".";
    }

    static {
        try (InputStream in = EnglishWords.class.getResourceAsStream("/net/morimekta/providence/testing/words.txt");
             InputStreamReader reader = new InputStreamReader(in);
             BufferedReader bufferedReader = new BufferedReader(reader);
             Stream<String> lines = bufferedReader.lines();){
            ArrayList nounsB = new ArrayList();
            ArrayList adjectivesB = new ArrayList();
            ArrayList verbsB = new ArrayList();
            lines.forEach(line -> {
                String[] word = line.split(" ", 3);
                if (word.length != 3) {
                    return;
                }
                if (word[2].contains("adjective")) {
                    adjectivesB.add(word[0]);
                } else if (word[2].contains("verb")) {
                    verbsB.add(word[0]);
                } else if (word[2].contains("noun")) {
                    nounsB.add(word[0]);
                }
            });
            nouns = UnmodifiableList.copyOf(nounsB);
            adjectives = UnmodifiableList.copyOf(adjectivesB);
            verbs = UnmodifiableList.copyOf(verbsB);
            random = new Random();
        }
        catch (IOException e) {
            LOGGER.error("Failed to load words: {}", (Object)e.getMessage(), (Object)e);
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }
}

