/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.testing.util.MessageDiff;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.UnmodifiableSet;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class EqualToMessage<Message extends PMessage<Message>>
extends BaseMatcher<PMessageOrBuilder<Message>> {
    private final PMessageOrBuilder<Message> expected;
    private final Set<PField> ignoringFields;

    public static <Message extends PMessage<Message>> EqualToMessage<Message> equalToMessage(PMessageOrBuilder<Message> expected) {
        return new EqualToMessage<Message>(expected);
    }

    public EqualToMessage(PMessageOrBuilder<Message> expected) {
        this.expected = expected.toMessage();
        this.ignoringFields = UnmodifiableSet.setOf();
    }

    private EqualToMessage(PMessageOrBuilder<Message> expected, Set<PField> ignoringFields) {
        this.expected = expected.toMessage();
        this.ignoringFields = ignoringFields;
    }

    public final EqualToMessage<Message> ignoring(PField ... fields) {
        return new EqualToMessage<Message>(this.expected, (Set<PField>)UnmodifiableSet.copyOf((Object[])fields));
    }

    public boolean matches(Object actual) {
        if (this.expected == null) {
            return actual == null;
        }
        if (!(actual instanceof PMessage)) {
            throw new AssertionError((Object)("Item " + actual.getClass().toString() + " not a providence message."));
        }
        if (!((PMessage)actual).descriptor().equals((Object)this.expected.descriptor())) {
            throw new AssertionError((Object)("Expected message type " + this.expected.descriptor().getQualifiedName() + ", but got " + ((PMessage)actual).descriptor().getQualifiedName()));
        }
        try {
            MessageDiff.collectMismatches("", this.expected, (PMessage)actual, (Set<PField>)UnmodifiableSet.copyOf(this.ignoringFields), str -> {
                throw new IllegalStateException();
            });
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("equals(").appendText(MessageDiff.limitToString(this.expected)).appendText(")");
    }

    public void describeMismatch(Object actual, Description mismatchDescription) {
        if (this.expected == null) {
            mismatchDescription.appendText("got " + EqualToMessage.toString(actual));
        } else if (actual == null) {
            mismatchDescription.appendText("got null");
        } else {
            ArrayList mismatches = new ArrayList();
            MessageDiff.collectMismatches("", this.expected, (PMessage)actual, (Set<PField>)UnmodifiableSet.copyOf(this.ignoringFields), mismatches::add);
            if (mismatches.size() == 1) {
                mismatchDescription.appendText((String)mismatches.get(0));
            } else {
                boolean first = true;
                mismatchDescription.appendText("[");
                int i = 0;
                for (String mismatch : mismatches) {
                    if (first) {
                        first = false;
                    } else {
                        mismatchDescription.appendText(",");
                    }
                    mismatchDescription.appendText("\n        ");
                    if (i >= 20) {
                        int remaining = mismatches.size() - i;
                        mismatchDescription.appendText("... and " + remaining + " more");
                        break;
                    }
                    mismatchDescription.appendText(mismatch);
                    ++i;
                }
                mismatchDescription.appendText("\n     ]");
            }
        }
    }

    protected static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof PMessage) {
            return MessageDiff.limitToString((PMessage)o);
        }
        if (o instanceof PEnumValue) {
            return ((PEnumValue)o).descriptor().getName() + "." + ((PEnumValue)o).asString();
        }
        if (o instanceof Map) {
            return "{" + Strings.join((String)",", (Collection)((Map)o).entrySet().stream().map(e -> EqualToMessage.toString(e.getKey()) + ":" + EqualToMessage.toString(e.getValue())).collect(Collectors.toList())) + "}";
        }
        if (o instanceof Collection) {
            return "[" + Strings.join((String)",", (Collection)((Collection)o).stream().map(EqualToMessage::toString).collect(Collectors.toList())) + "]";
        }
        if (o instanceof CharSequence) {
            return "\"" + Strings.escape((CharSequence)o.toString()) + "\"";
        }
        if (o instanceof Binary) {
            int len = ((Binary)o).length();
            if (len > 110) {
                return String.format(Locale.US, "binary[%s...+%d]", ((Binary)o).toHexString().substring(0, 100), len - 50);
            }
            return "binary[" + ((Binary)o).toHexString() + "]";
        }
        if (o instanceof Double) {
            long l = ((Double)o).longValue();
            if (o.equals(l)) {
                return Long.toString(l);
            }
            return o.toString();
        }
        return o.toString();
    }
}

