/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.generator;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.testing.generator.Generator;
import net.morimekta.providence.testing.generator.GeneratorContext;

@FunctionalInterface
public interface MessageFieldGenerator<M extends PMessage<M>, MB extends PMessageOrBuilder<M>, C extends GeneratorContext<C>, T> {
    public T generate(MB var1, C var2);

    public static class Conditional<M extends PMessage<M>, MB extends PMessageOrBuilder<M>, C extends GeneratorContext<C>, T>
    implements MessageFieldGenerator<M, MB, C, T> {
        private final Predicate<MB> predicate;
        private final MessageFieldGenerator<M, MB, C, T> generator;

        public Conditional(@Nonnull Predicate<MB> predicate, @Nonnull MessageFieldGenerator<M, MB, C, T> generator) {
            this.predicate = predicate;
            this.generator = generator;
        }

        @Override
        public T generate(MB message, C context) {
            if (this.predicate.test(message)) {
                return this.generator.generate(message, context);
            }
            return null;
        }
    }

    public static class Wrapper<M extends PMessage<M>, MB extends PMessageOrBuilder<M>, C extends GeneratorContext<C>, T>
    implements MessageFieldGenerator<M, MB, C, T> {
        private final Generator<C, T> generator;

        public Wrapper(Generator<C, T> generator) {
            this.generator = generator;
        }

        @Override
        public T generate(MB message, C generator) {
            return this.generator.generate(generator);
        }
    }
}

