/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;

public class MessageDiff {
    private MessageDiff() {
    }

    public static <T extends PMessage<T>> void collectMismatches(String xPath, PMessageOrBuilder<T> expected, PMessageOrBuilder<T> actual, Set<PField> ignoringFields, MismatchHandler mismatches) {
        if (expected.descriptor().getVariant() == PMessageVariant.UNION) {
            PUnion eu = (PUnion)expected;
            PUnion ac = (PUnion)actual;
            if (eu.unionFieldIsSet() != ac.unionFieldIsSet()) {
                if (eu.unionFieldIsSet()) {
                    mismatches.onMismatch("unexpected value in " + xPath);
                } else {
                    mismatches.onMismatch("expected value in " + xPath + " but not set");
                }
            } else if (!eu.unionField().equals(ac.unionField())) {
                mismatches.onMismatch(String.format(Locale.US, "%s to be %s, but was %s", xPath, eu.unionField().getName(), ac.unionField().getName()));
            }
        }
        block6: for (PField field : expected.descriptor().getFields()) {
            String fieldXPath;
            if (ignoringFields.contains(field)) continue;
            int key = field.getId();
            String string = fieldXPath = xPath.isEmpty() ? field.getName() : xPath + "." + field.getName();
            if (expected.has(key) != actual.has(key)) {
                if (!expected.has(key)) {
                    mismatches.onMismatch(String.format(Locale.US, "%s to be missing, but was %s", fieldXPath, MessageDiff.toString(actual.get(field.getId()))));
                    continue;
                }
                if (actual.has(key)) continue;
                mismatches.onMismatch(String.format(Locale.US, "%s to be %s, but was missing", fieldXPath, MessageDiff.toString(expected.get(field.getId()))));
                continue;
            }
            if (Objects.equals(expected.get(key), actual.get(key))) continue;
            switch (field.getType()) {
                case MESSAGE: {
                    MessageDiff.collectMismatches(fieldXPath, (PMessageOrBuilder)expected.get(key), (PMessageOrBuilder)actual.get(key), ignoringFields, mismatches);
                    continue block6;
                }
                case LIST: {
                    MessageDiff.collectListMismatches(fieldXPath, (List)expected.get(key), (List)actual.get(key), ignoringFields, mismatches);
                    continue block6;
                }
                case SET: {
                    MessageDiff.collectSetMismatches(fieldXPath, (Set)expected.get(key), (Set)actual.get(key), mismatches);
                    continue block6;
                }
                case MAP: {
                    MessageDiff.collectMapMismatches(fieldXPath, (Map)expected.get(key), (Map)actual.get(key), ignoringFields, mismatches);
                    continue block6;
                }
                default: {
                    mismatches.onMismatch(String.format(Locale.US, "%s was %s, expected %s", fieldXPath, MessageDiff.toString(actual.get(field.getId())), MessageDiff.toString(expected.get(field.getId()))));
                }
            }
        }
    }

    private static <K, V> void collectMapMismatches(String xPath, Map<K, V> expected, Map<K, V> actual, Set<PField> ignoringFields, MismatchHandler mismatches) {
        actual.keySet().stream().filter(key -> !expected.containsKey(key)).map(key -> String.format(Locale.US, "found unexpected entry (%s, %s) in %s", MessageDiff.toString(key), MessageDiff.toString(actual.get(key)), xPath)).forEach(mismatches::onMismatch);
        for (Map.Entry<K, V> entry : expected.entrySet()) {
            V act;
            if (!actual.keySet().contains(entry.getKey())) {
                mismatches.onMismatch(String.format(Locale.US, "did not find entry (%s, %s) in in %s", MessageDiff.toString(entry.getKey()), MessageDiff.toString(expected.get(entry.getKey())), xPath));
                continue;
            }
            V exp = entry.getValue();
            if (Objects.equals(exp, act = actual.get(entry.getKey()))) continue;
            String keyedXPath = String.format(Locale.US, "%s[%s]", xPath, MessageDiff.toString(entry));
            if (exp == null || act == null) {
                mismatches.onMismatch(String.format(Locale.US, "%s was %s, should be %s", keyedXPath, MessageDiff.toString(exp), MessageDiff.toString(act)));
                continue;
            }
            if (act instanceof PMessage) {
                MessageDiff.collectMismatches(keyedXPath, (PMessage)exp, (PMessage)act, ignoringFields, mismatches);
                continue;
            }
            mismatches.onMismatch(String.format(Locale.US, "%s was %s, should be %s", keyedXPath, MessageDiff.toString(act), MessageDiff.toString(exp)));
        }
    }

    private static <T> void collectSetMismatches(String xPath, Set<T> expected, Set<T> actual, MismatchHandler mismatches) {
        actual.stream().filter(item -> !expected.contains(item)).map(item -> String.format(Locale.US, "found unexpected set value %s in %s", MessageDiff.toString(item), xPath)).forEach(mismatches::onMismatch);
        expected.stream().filter(item -> !actual.contains(item)).map(item -> String.format(Locale.US, "did not find value %s in %s", MessageDiff.toString(item), xPath)).forEach(mismatches::onMismatch);
    }

    private static <T> void collectListMismatches(String xPath, List<T> expected, List<T> actual, Set<PField> ignoringFields, MismatchHandler mismatches) {
        HashSet<T> handledItems = new HashSet<T>();
        boolean hasReorder = false;
        ArrayList<String> reordering = new ArrayList<String>();
        for (int expectedIndex = 0; expectedIndex < expected.size(); ++expectedIndex) {
            Object actualItem;
            String indexedXPath = String.format(Locale.US, "%s[%d]", xPath, expectedIndex);
            T expectedItem = expected.get(expectedIndex);
            handledItems.add(expectedItem);
            Object e = actualItem = actual.size() > expectedIndex ? (Object)actual.get(expectedIndex) : null;
            if (Objects.equals(expectedItem, actualItem)) continue;
            int actualIndex = actual.indexOf(expectedItem);
            int actualItemExpectedIndex = -1;
            if (actualItem != null) {
                actualItemExpectedIndex = expected.indexOf(actualItem);
            }
            if (actualIndex < 0) {
                reordering.add("NaN");
                if (actualItemExpectedIndex < 0) {
                    handledItems.add(actualItem);
                    if (actualItem instanceof PMessage) {
                        MessageDiff.collectMismatches(indexedXPath, (PMessage)expectedItem, (PMessage)actualItem, ignoringFields, mismatches);
                        continue;
                    }
                    mismatches.onMismatch(String.format(Locale.US, "expected %s to be %s, but was %s", indexedXPath, MessageDiff.toString(expectedItem), MessageDiff.toString(actualItem)));
                    continue;
                }
                mismatches.onMismatch(String.format(Locale.US, "missing item %s in %s", MessageDiff.toString(expectedItem), indexedXPath));
                continue;
            }
            if (actualIndex != expectedIndex) {
                reordering.add(String.format(Locale.US, "%+d", actualIndex - expectedIndex));
                hasReorder = true;
                continue;
            }
            reordering.add("\u00b10");
        }
        for (int actualIndex = 0; actualIndex < actual.size(); ++actualIndex) {
            T actualItem = actual.get(actualIndex);
            if (handledItems.contains(actualItem) || expected.contains(actualItem)) continue;
            String indexedXPath = String.format(Locale.US, "%s[%d]", xPath, actualIndex);
            mismatches.onMismatch(String.format(Locale.US, "unexpected item %s in %s", MessageDiff.toString(actualItem), indexedXPath));
        }
        if (hasReorder) {
            mismatches.onMismatch(String.format(Locale.US, "unexpected item ordering in %s: [%s]", xPath, Strings.join((String)",", reordering)));
        }
    }

    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof PMessage) {
            return MessageDiff.limitToString((PMessage)o);
        }
        if (o instanceof PEnumValue) {
            PEnumValue v = (PEnumValue)o;
            return v.descriptor().getName() + "." + v.asString();
        }
        if (o instanceof Map) {
            return "{" + Strings.join((String)",", (Collection)((Map)o).entrySet().stream().map(e -> MessageDiff.toString(e.getKey()) + ":" + MessageDiff.toString(e.getValue())).collect(Collectors.toList())) + "}";
        }
        if (o instanceof Collection) {
            return "[" + Strings.join((String)",", (Collection)((Collection)o).stream().map(MessageDiff::toString).collect(Collectors.toList())) + "]";
        }
        if (o instanceof CharSequence) {
            return "\"" + Strings.escape((CharSequence)o.toString()) + "\"";
        }
        if (o instanceof Binary) {
            int len = ((Binary)o).length();
            if (len > 110) {
                return String.format(Locale.US, "binary[%s...+%d]", ((Binary)o).toHexString().substring(0, 100), len - 50);
            }
            return "binary[" + ((Binary)o).toHexString() + "]";
        }
        if (o instanceof Double) {
            long l = ((Double)o).longValue();
            if (o.equals(l)) {
                return "<" + l + ">";
            }
            return "<" + o.toString() + ">";
        }
        return "<" + o.toString() + ">";
    }

    public static <M extends PMessage<M>> String limitToString(PMessageOrBuilder<M> message) {
        String tos;
        String string = tos = message == null ? "null" : message.toMessage().asString();
        if (tos.length() > 120) {
            tos = tos.substring(0, 110) + "...}";
        }
        return tos;
    }

    public static interface MismatchHandler {
        public void onMismatch(String var1);
    }
}

