/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.testing.generator.Generator;
import net.morimekta.providence.testing.generator.GeneratorContext;
import net.morimekta.providence.testing.generator.MessageFieldGenerator;
import net.morimekta.util.collect.UnmodifiableList;

public class MessageGenerator<Context extends GeneratorContext<Context>, Message extends PMessage<Message>, MessageOrBuilder extends PMessageOrBuilder<Message>>
implements Generator<Context, Message> {
    private final PMessageDescriptor<Message> descriptor;
    private final Map<PField<Message>, MessageFieldGenerator<Message, MessageOrBuilder, Context, ?>> fieldValueGenerators;
    private final Map<PField<Message>, Boolean> fieldPresenceOverrides;
    private final List<PField<Message>> fieldOrder;

    public MessageGenerator(PMessageDescriptor<Message> descriptor) {
        this.descriptor = descriptor;
        this.fieldValueGenerators = new HashMap();
        this.fieldPresenceOverrides = new HashMap<PField<Message>, Boolean>();
        this.fieldOrder = new ArrayList<PField<Message>>(UnmodifiableList.copyOf((Object[])descriptor.getFields()));
    }

    private MessageGenerator(MessageGenerator<Context, Message, MessageOrBuilder> parent) {
        this.descriptor = parent.descriptor;
        this.fieldValueGenerators = new HashMap(parent.fieldValueGenerators);
        this.fieldPresenceOverrides = new HashMap<PField<Message>, Boolean>(parent.fieldPresenceOverrides);
        this.fieldOrder = new ArrayList<PField<Message>>(parent.fieldOrder);
    }

    public MessageGenerator<Context, Message, MessageOrBuilder> deepCopy() {
        return new MessageGenerator<Context, Message, MessageOrBuilder>(this);
    }

    @SafeVarargs
    public final MessageGenerator<Context, Message, MessageOrBuilder> setAlwaysPresent(PField<Message> ... fields) {
        return this.setAlwaysPresent(Arrays.asList(fields));
    }

    public MessageGenerator<Context, Message, MessageOrBuilder> setAlwaysPresent(@Nonnull Collection<PField<Message>> fields) {
        for (PField<Message> field : fields) {
            this.fieldPresenceOverrides.put(field, Boolean.TRUE);
        }
        return this;
    }

    @SafeVarargs
    public final MessageGenerator<Context, Message, MessageOrBuilder> setAlwaysAbsent(PField<Message> ... fields) {
        return this.setAlwaysAbsent(Arrays.asList(fields));
    }

    public MessageGenerator<Context, Message, MessageOrBuilder> setAlwaysAbsent(@Nonnull Collection<PField<Message>> fields) {
        for (PField<Message> field : fields) {
            this.fieldPresenceOverrides.put(field, Boolean.FALSE);
        }
        return this;
    }

    @SafeVarargs
    public final MessageGenerator<Context, Message, MessageOrBuilder> setDefaultPresence(PField<Message> ... fields) {
        return this.setDefaultPresence(Arrays.asList(fields));
    }

    public MessageGenerator<Context, Message, MessageOrBuilder> setDefaultPresence(@Nonnull Collection<PField<Message>> fields) {
        for (PField<Message> field : fields) {
            this.fieldPresenceOverrides.remove(field);
        }
        return this;
    }

    public MessageGenerator<Context, Message, MessageOrBuilder> resetDefaultPresence() {
        this.fieldPresenceOverrides.clear();
        return this;
    }

    @SafeVarargs
    public final MessageGenerator<Context, Message, MessageOrBuilder> setFirstFields(PField<Message> ... fields) {
        return this.setFirstFields((Collection<PField<Message>>)UnmodifiableList.copyOf((Object[])fields));
    }

    public MessageGenerator<Context, Message, MessageOrBuilder> setFirstFields(@Nonnull Collection<PField<Message>> fields) {
        this.fieldOrder.removeAll(fields);
        this.fieldOrder.addAll(0, fields);
        return this;
    }

    @SafeVarargs
    public final MessageGenerator<Context, Message, MessageOrBuilder> setLastFields(PField<Message> ... fields) {
        return this.setLastFields((Collection<PField<Message>>)UnmodifiableList.copyOf((Object[])fields));
    }

    public MessageGenerator<Context, Message, MessageOrBuilder> setLastFields(@Nonnull Collection<PField<Message>> fields) {
        this.fieldOrder.removeAll(fields);
        this.fieldOrder.addAll(fields);
        return this;
    }

    public MessageGenerator<Context, Message, MessageOrBuilder> setValueGenerator(@Nonnull PField<Message> field, @Nonnull Generator<Context, ?> generator) {
        return this.setFieldGenerator(field, new MessageFieldGenerator.Wrapper(generator));
    }

    public MessageGenerator<Context, Message, MessageOrBuilder> setFieldGenerator(@Nonnull PField<Message> field, @Nonnull MessageFieldGenerator<Message, MessageOrBuilder, Context, ?> valueGenerator) {
        this.fieldValueGenerators.put(field, valueGenerator);
        return this;
    }

    public MessageGenerator<Context, Message, MessageOrBuilder> setValueGenerator(@Nonnull PField<Message> field, @Nonnull Predicate<MessageOrBuilder> predicate, @Nonnull Generator<Context, ?> generator) {
        return this.setFieldGenerator(field, predicate, new MessageFieldGenerator.Wrapper(generator));
    }

    public MessageGenerator<Context, Message, MessageOrBuilder> setFieldGenerator(@Nonnull PField<Message> field, @Nonnull Predicate<MessageOrBuilder> predicate, @Nonnull MessageFieldGenerator<Message, MessageOrBuilder, Context, ?> valueGenerator) {
        return this.setFieldGenerator(field, new MessageFieldGenerator.Conditional(predicate, valueGenerator));
    }

    @Override
    public Message generate(Context ctx) {
        PMessageBuilder builder = this.descriptor.builder();
        if (this.descriptor.getVariant() == PMessageVariant.UNION) {
            PField selectedField = null;
            HashSet<PField<Message>> blockedFields = new HashSet<PField<Message>>();
            for (Map.Entry<PField<Message>, Boolean> entry : this.fieldPresenceOverrides.entrySet()) {
                if (entry.getValue().booleanValue()) {
                    if (selectedField != null) {
                        throw new IllegalStateException("More than one required union field");
                    }
                    selectedField = entry.getKey();
                    continue;
                }
                blockedFields.add(entry.getKey());
            }
            if (selectedField == null) {
                ArrayList<PField> allowed = new ArrayList<PField>(Arrays.asList(this.descriptor.getFields()));
                allowed.removeAll(blockedFields);
                if (allowed.size() < 1) {
                    throw new IllegalStateException("No remaining fields allowed after " + blockedFields.size() + " was blocked");
                }
                int idx = ((GeneratorContext)ctx).getRandom().nextInt(allowed.size());
                selectedField = allowed.get(idx);
            }
            builder.set(selectedField, this.makeFieldValue(builder, selectedField, ctx));
        } else {
            for (PField<Message> field : this.fieldOrder) {
                if (this.fieldPresenceOverrides.containsKey(field)) {
                    if (!this.fieldPresenceOverrides.get(field).booleanValue()) continue;
                    builder.set(field, this.makeFieldValue(builder, field, ctx));
                    continue;
                }
                if (field.getRequirement() != PRequirement.REQUIRED && !((GeneratorContext)ctx).nextFieldIsPresent()) continue;
                builder.set(field, this.makeFieldValue(builder, field, ctx));
            }
        }
        PMessage message = (PMessage)builder.build();
        ((GeneratorContext)ctx).addGeneratedMessage(message);
        return (Message)message;
    }

    private Object makeFieldValue(MessageOrBuilder instance, PField<Message> field, Context context) {
        MessageFieldGenerator<Message, MessageOrBuilder, Context, ?> valueGenerator = this.fieldValueGenerators.get(field);
        if (valueGenerator == null) {
            return ((GeneratorContext)context).generatorForDescriptor(field.getDescriptor()).generate(context);
        }
        return valueGenerator.generate(instance, context);
    }
}

