/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.generator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.testing.generator.Generator;
import net.morimekta.providence.testing.generator.MessageGenerator;
import net.morimekta.providence.testing.generator.defaults.BinaryGenerator;
import net.morimekta.providence.testing.generator.defaults.BoolGenerator;
import net.morimekta.providence.testing.generator.defaults.ByteGenerator;
import net.morimekta.providence.testing.generator.defaults.DoubleGenerator;
import net.morimekta.providence.testing.generator.defaults.EnumGenerator;
import net.morimekta.providence.testing.generator.defaults.IntGenerator;
import net.morimekta.providence.testing.generator.defaults.ListGenerator;
import net.morimekta.providence.testing.generator.defaults.LongGenerator;
import net.morimekta.providence.testing.generator.defaults.MapGenerator;
import net.morimekta.providence.testing.generator.defaults.SetGenerator;
import net.morimekta.providence.testing.generator.defaults.ShortGenerator;
import net.morimekta.providence.testing.generator.defaults.StringGenerator;
import net.morimekta.providence.testing.generator.defaults.VoidGenerator;
import net.morimekta.util.collect.UnmodifiableList;

public class GeneratorContext<Context extends GeneratorContext<Context>> {
    private final Map<PDescriptor, Generator<Context, ?>> generatorMap;
    private final Map<String, Object> persistentProperties;
    private final List<PMessage> generatedMessages;
    private Random random;
    private double fillRate;
    private int minCollectionSize;
    private int naxCollectionSize;

    public GeneratorContext() {
        this.random = new Random();
        this.generatorMap = new HashMap();
        this.persistentProperties = new HashMap<String, Object>();
        this.fillRate = 1.0;
        this.minCollectionSize = 0;
        this.naxCollectionSize = 10;
        this.generatedMessages = new ArrayList<PMessage>();
    }

    protected GeneratorContext(GeneratorContext<Context> parent) {
        this.random = parent.random;
        this.generatorMap = new HashMap(parent.generatorMap);
        this.persistentProperties = new HashMap<String, Object>(parent.persistentProperties);
        this.fillRate = parent.fillRate;
        this.minCollectionSize = parent.minCollectionSize;
        this.naxCollectionSize = parent.naxCollectionSize;
        this.generatedMessages = parent.generatedMessages;
    }

    public Context deepCopy() {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(this.getClass());
            return (Context)((GeneratorContext)constructor.newInstance(this));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError("No usable copy constructor for " + this.getClass(), e);
        }
    }

    public Context setFillRate(double v) {
        this.fillRate = v;
        return this.self();
    }

    public Context setMinCollectionSize(int v) {
        this.minCollectionSize = v;
        return this.self();
    }

    public Context setMaxCollectionSize(int v) {
        this.naxCollectionSize = v;
        return this.self();
    }

    public Random getRandom() {
        return this.random;
    }

    public Context setRandom(Random random) {
        this.random = random;
        return this.self();
    }

    public <V> V getProperty(String name) {
        return (V)this.persistentProperties.get(name);
    }

    public <V> V createPropertyIfAbsent(String name, Supplier<V> propertySupplier) {
        return (V)this.persistentProperties.computeIfAbsent(name, n -> propertySupplier.get());
    }

    public <V> Context setProperty(String name, V value) {
        this.persistentProperties.put(name, value);
        return this.self();
    }

    @Nonnull
    public <V> Context withGenerator(PDescriptor descriptor, Generator<Context, V> generator) {
        this.generatorMap.put(descriptor, generator);
        return this.self();
    }

    @Nonnull
    public <M extends PMessage<M>, VG extends Generator<Context, M>> VG generatorFor(@Nonnull PMessageDescriptor<M> descriptor) {
        return (VG)this.generatorForDescriptor((PDescriptor)descriptor);
    }

    @Nonnull
    public Generator<Context, ?> generatorForDescriptor(@Nonnull PDescriptor descriptor) {
        return this.generatorMap.computeIfAbsent(descriptor, d -> this.makeGeneratorInternal(descriptor));
    }

    @Nonnull
    public <M extends PMessage<M>, MOB extends PMessageOrBuilder<M>> GeneratorContext<Context> withMessageGenerator(@Nonnull PMessageDescriptor<M> descriptor, @Nonnull Consumer<MessageGenerator<Context, M, MOB>> closure) {
        this.generatorMap.compute((PDescriptor)descriptor, (BiFunction<PDescriptor, Generator<Context, ?>, Generator<Context, ?>>)((BiFunction<PDescriptor, Generator, Generator>)(d, gen) -> {
            MessageGenerator mg = (MessageGenerator)gen;
            mg = mg == null ? new MessageGenerator(descriptor) : mg.deepCopy();
            closure.accept(mg);
            return mg;
        }));
        return this;
    }

    public <M extends PMessage<M>> M nextMessage(@Nonnull PMessageDescriptor<M> descriptor) {
        return (M)((PMessage)this.generatorMap.computeIfAbsent((PDescriptor)descriptor, (Function<PDescriptor, Generator<Context, ?>>)((Function<PDescriptor, Generator>)d -> new MessageGenerator(descriptor))).generate(this.self()));
    }

    public <M extends PMessage<M>, MOB extends PMessageOrBuilder<M>> M nextMessage(@Nonnull PMessageDescriptor<M> descriptor, @Nonnull Consumer<MessageGenerator<Context, M, MOB>> closure) {
        MessageGenerator generator = (MessageGenerator)this.generatorMap.get(descriptor);
        generator = generator == null ? new MessageGenerator(descriptor) : generator.deepCopy();
        closure.accept(generator);
        return (M)generator.generate(this.self());
    }

    public int nextCollectionSize() {
        return this.minCollectionSize + this.getRandom().nextInt(this.naxCollectionSize - this.minCollectionSize);
    }

    public boolean nextFieldIsPresent() {
        return this.getRandom().nextDouble() < this.fillRate;
    }

    public List<PMessage> getGeneratedMessages() {
        return UnmodifiableList.copyOf(this.generatedMessages);
    }

    public void clearGeneratedMessages() {
        this.generatedMessages.clear();
    }

    void addGeneratedMessage(PMessage message) {
        this.generatedMessages.add(message);
    }

    @Nonnull
    private Context self() {
        return (Context)this;
    }

    @Nonnull
    private <T> Generator<Context, T> makeGeneratorInternal(@Nonnull PDescriptor type) {
        switch (type.getType()) {
            case VOID: {
                return new VoidGenerator();
            }
            case BOOL: {
                return new BoolGenerator();
            }
            case BYTE: {
                return new ByteGenerator();
            }
            case I16: {
                return new ShortGenerator();
            }
            case I32: {
                return new IntGenerator();
            }
            case I64: {
                return new LongGenerator();
            }
            case DOUBLE: {
                return new DoubleGenerator();
            }
            case STRING: {
                return new StringGenerator();
            }
            case BINARY: {
                return new BinaryGenerator();
            }
            case LIST: {
                return new ListGenerator((PList<Object>)((PList)type));
            }
            case SET: {
                return new SetGenerator((PSet<Object>)((PSet)type));
            }
            case MAP: {
                return new MapGenerator((PMap<Object, Object>)((PMap)type));
            }
            case ENUM: {
                return new EnumGenerator((PEnumDescriptor)type);
            }
            case MESSAGE: {
                return new MessageGenerator((PMessageDescriptor)type);
            }
        }
        throw new IllegalArgumentException("Unhandled default type: " + type.getType());
    }

    public static final class Simple
    extends GeneratorContext<Simple> {
        public Simple() {
        }

        public Simple(Simple generator) {
            super(generator);
        }
    }
}

