/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import junit.framework.AssertionFailedError;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class EqualToMessage<Message extends PMessage<Message, Field>, Field extends PField>
extends BaseMatcher<Message> {
    private final Message expected;
    private final Set<PField> ignoringFields;

    public EqualToMessage(Message expected) {
        this.expected = expected;
        this.ignoringFields = ImmutableSet.of();
    }

    private EqualToMessage(Message expected, Set<PField> ignoringFields) {
        this.expected = expected;
        this.ignoringFields = ignoringFields;
    }

    public EqualToMessage<Message, Field> ignoring(PField ... fields) {
        return new EqualToMessage<Message, Field>(this.expected, (Set<PField>)ImmutableSet.copyOf((Object[])fields));
    }

    public boolean matches(Object actual) {
        if (this.expected == null) {
            return actual == null;
        }
        if (!(actual instanceof PMessage)) {
            throw new AssertionFailedError("Item " + actual.getClass().toString() + " not a providence message.");
        }
        ArrayList<String> mismatches = new ArrayList<String>();
        this.collectMismatches("", (PMessage)this.expected, (PMessage)((PMessage)actual), mismatches);
        return mismatches.isEmpty();
    }

    public void describeTo(Description description) {
        description.appendText("equals(").appendText(EqualToMessage.limitToString(this.expected)).appendText(")");
    }

    public void describeMismatch(Object actual, Description mismatchDescription) {
        if (this.expected == null) {
            mismatchDescription.appendText("got " + EqualToMessage.toString(actual));
        } else if (actual == null) {
            mismatchDescription.appendText("got null");
        } else {
            ArrayList<String> mismatches = new ArrayList<String>();
            this.collectMismatches("", (PMessage)this.expected, (PMessage)((PMessage)actual), mismatches);
            if (mismatches.size() == 1) {
                mismatchDescription.appendText(mismatches.get(0));
            } else {
                boolean first = true;
                mismatchDescription.appendText("[");
                int i = 0;
                for (String mismatch : mismatches) {
                    if (first) {
                        first = false;
                    } else {
                        mismatchDescription.appendText(",");
                    }
                    mismatchDescription.appendText("\n        ");
                    if (i >= 20) {
                        int remaining = mismatches.size() - i;
                        mismatchDescription.appendText("... and " + remaining + " more");
                        break;
                    }
                    mismatchDescription.appendText(mismatch);
                    ++i;
                }
                mismatchDescription.appendText("\n     ]");
            }
        }
    }

    private <T extends PMessage<T, F>, F extends PField> void collectMismatches(String xPath, T expected, T actual, ArrayList<String> mismatches) {
        if (expected.descriptor().getVariant() == PMessageVariant.UNION) {
            PUnion eu = (PUnion)expected;
            PUnion ac = (PUnion)actual;
            if (!eu.unionField().equals(ac.unionField())) {
                mismatches.add(String.format(Locale.US, "%s to have %s, but had %s", xPath, eu.unionField().getName(), ac.unionField().getName()));
            }
        }
        block6: for (PField field : expected.descriptor().getFields()) {
            String fieldXPath;
            if (this.ignoringFields.contains(field)) continue;
            int key = field.getId();
            String string = fieldXPath = xPath.isEmpty() ? field.getName() : xPath + "." + field.getName();
            if (expected.has(key) != actual.has(key)) {
                if (!expected.has(key)) {
                    mismatches.add(String.format(Locale.US, "%s to be missing, but was %s", fieldXPath, EqualToMessage.toString(actual.get(field.getId()))));
                    continue;
                }
                if (actual.has(key)) continue;
                mismatches.add(String.format(Locale.US, "%s to be %s, but was missing", fieldXPath, EqualToMessage.toString(expected.get(field.getId()))));
                continue;
            }
            if (Objects.equals(expected.get(key), actual.get(key))) continue;
            switch (field.getType()) {
                case MESSAGE: {
                    this.collectMismatches(fieldXPath, (PMessage)expected.get(key), (PMessage)actual.get(key), mismatches);
                    continue block6;
                }
                case LIST: {
                    this.collectListMismatches(fieldXPath, (List)expected.get(key), (List)actual.get(key), mismatches);
                    continue block6;
                }
                case SET: {
                    EqualToMessage.collectSetMismatches(fieldXPath, (Set)expected.get(key), (Set)actual.get(key), mismatches);
                    continue block6;
                }
                case MAP: {
                    this.collectMapMismatches(fieldXPath, (Map)expected.get(key), (Map)actual.get(key), mismatches);
                    continue block6;
                }
                default: {
                    mismatches.add(String.format(Locale.US, "%s was %s, expected %s", fieldXPath, EqualToMessage.toString(actual.get(field.getId())), EqualToMessage.toString(expected.get(field.getId()))));
                }
            }
        }
    }

    private <K, V> void collectMapMismatches(String xPath, Map<K, V> expected, Map<K, V> actual, ArrayList<String> mismatches) {
        mismatches.addAll(actual.keySet().stream().filter(key -> !expected.keySet().contains(key)).map(key -> String.format(Locale.US, "found unexpected entry (%s, %s) in %s", EqualToMessage.toString(key), EqualToMessage.toString(actual.get(key)), xPath)).collect(Collectors.toList()));
        for (Map.Entry<K, V> entry : expected.entrySet()) {
            V act;
            if (!actual.keySet().contains(entry.getKey())) {
                mismatches.add(String.format(Locale.US, "did not find entry (%s, %s) in in %s", EqualToMessage.toString(entry.getKey()), EqualToMessage.toString(expected.get(entry.getKey())), xPath));
                continue;
            }
            V exp = entry.getValue();
            if (Objects.equals(exp, act = actual.get(entry.getKey()))) continue;
            String keyedXPath = String.format(Locale.US, "%s[%s]", xPath, EqualToMessage.toString(entry));
            if (exp == null || act == null) {
                mismatches.add(String.format(Locale.US, "%s was %s, should be %s", keyedXPath, EqualToMessage.toString(exp), EqualToMessage.toString(act)));
                continue;
            }
            if (act instanceof PMessage) {
                this.collectMismatches(keyedXPath, (PMessage)exp, (PMessage)act, mismatches);
                continue;
            }
            mismatches.add(String.format(Locale.US, "%s was %s, should be %s", keyedXPath, EqualToMessage.toString(act), EqualToMessage.toString(exp)));
        }
    }

    private static <T> void collectSetMismatches(String xPath, Set<T> expected, Set<T> actual, ArrayList<String> mismatches) {
        mismatches.addAll(actual.stream().filter(item -> !expected.contains(item)).map(item -> String.format(Locale.US, "found unexpected set value %s in %s", EqualToMessage.toString(item), xPath)).collect(Collectors.toList()));
        mismatches.addAll(expected.stream().filter(item -> !actual.contains(item)).map(item -> String.format(Locale.US, "did not find value %s in %s", EqualToMessage.toString(item), xPath)).collect(Collectors.toList()));
    }

    private <T> void collectListMismatches(String xPath, List<T> expected, List<T> actual, ArrayList<String> mismatches) {
        HashSet<T> handledItems = new HashSet<T>();
        boolean hasReorder = false;
        ArrayList<String> reordering = new ArrayList<String>();
        for (int expectedIndex = 0; expectedIndex < expected.size(); ++expectedIndex) {
            Object actualItem;
            String indexedXPath = String.format(Locale.US, "%s[%d]", xPath, expectedIndex);
            T expectedItem = expected.get(expectedIndex);
            handledItems.add(expectedItem);
            Object e = actualItem = actual.size() > expectedIndex ? (Object)actual.get(expectedIndex) : null;
            if (Objects.equals(expectedItem, actualItem)) continue;
            int actualIndex = actual.indexOf(expectedItem);
            int actualItemExpectedIndex = -1;
            if (actualItem != null) {
                actualItemExpectedIndex = expected.indexOf(actualItem);
            }
            if (actualIndex < 0) {
                reordering.add("NaN");
                if (actualItemExpectedIndex < 0) {
                    handledItems.add(actualItem);
                    if (actualItem instanceof PMessage) {
                        this.collectMismatches(indexedXPath, (PMessage)expectedItem, (PMessage)actualItem, mismatches);
                        continue;
                    }
                    mismatches.add(String.format(Locale.US, "expected %s to be %s, but was %s", indexedXPath, EqualToMessage.toString(expectedItem), EqualToMessage.toString(actualItem)));
                    continue;
                }
                mismatches.add(String.format(Locale.US, "missing item %s in %s", EqualToMessage.toString(expectedItem), indexedXPath));
                continue;
            }
            if (actualIndex != expectedIndex) {
                reordering.add(String.format(Locale.US, "%+d", actualIndex - expectedIndex));
                hasReorder = true;
                continue;
            }
            reordering.add("\u00b10");
        }
        for (int actualIndex = 0; actualIndex < actual.size(); ++actualIndex) {
            T actualItem = actual.get(actualIndex);
            if (handledItems.contains(actualItem) || expected.contains(actualItem)) continue;
            String indexedXPath = String.format(Locale.US, "%s[%d]", xPath, actualIndex);
            mismatches.add(String.format(Locale.US, "unexpected item %s in %s", EqualToMessage.toString(actualItem), indexedXPath));
        }
        if (hasReorder) {
            mismatches.add(String.format(Locale.US, "unexpected item ordering in %s: [%s]", xPath, Strings.join((String)",", reordering)));
        }
    }

    protected static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof PMessage) {
            return EqualToMessage.limitToString((PMessage)o);
        }
        if (o instanceof PEnumValue) {
            return ((PEnumValue)o).descriptor().getName() + "." + ((PEnumValue)o).asString();
        }
        if (o instanceof Map) {
            return "{" + Strings.join((String)",", (Collection)((Map)o).entrySet().stream().map(e -> EqualToMessage.toString(e.getKey()) + ":" + EqualToMessage.toString(e.getValue())).collect(Collectors.toList())) + "}";
        }
        if (o instanceof Collection) {
            return "[" + Strings.join((String)",", (Collection)((Collection)o).stream().map(EqualToMessage::toString).collect(Collectors.toList())) + "]";
        }
        if (o instanceof CharSequence) {
            return "\"" + Strings.escape((CharSequence)o.toString()) + "\"";
        }
        if (o instanceof Binary) {
            int len = ((Binary)o).length();
            if (len > 110) {
                return String.format(Locale.US, "binary[%s...+%d]", ((Binary)o).toHexString().substring(0, 100), len - 50);
            }
            return "binary[" + ((Binary)o).toHexString() + "]";
        }
        if (o instanceof Double) {
            long l = ((Double)o).longValue();
            if (o.equals(l)) {
                return Long.toString(l);
            }
            return o.toString();
        }
        return o.toString();
    }

    private static String limitToString(PMessage<?, ?> message) {
        String tos;
        String string = tos = message == null ? "null" : message.asString();
        if (tos.length() > 120) {
            tos = tos.substring(0, 110) + "...}";
        }
        return tos;
    }
}

