/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.generator.extra;

import net.morimekta.providence.testing.generator.Generator;
import net.morimekta.providence.testing.generator.GeneratorContext;

public class DoubleRangeGenerator<Context extends GeneratorContext<Context>>
implements Generator<Context, Double> {
    private final double fromIncluding;
    private final double toExcluding;

    public DoubleRangeGenerator(double fromIncluding, double toExcluding) {
        this.fromIncluding = fromIncluding;
        this.toExcluding = toExcluding;
        if (fromIncluding >= toExcluding) {
            throw new AssertionError((Object)("Invalid range [ " + fromIncluding + " .. " + toExcluding + " >"));
        }
    }

    @Override
    public Double generate(Context ctx) {
        return this.fromIncluding + Math.abs(((GeneratorContext)ctx).getRandom().nextDouble() * (this.toExcluding - this.fromIncluding));
    }
}

