/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.generator.extra;

import java.util.Collection;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.testing.generator.GeneratorContext;
import net.morimekta.providence.testing.generator.extra.ByteRangeGenerator;
import net.morimekta.providence.testing.generator.extra.DoubleRangeGenerator;
import net.morimekta.providence.testing.generator.extra.EnumNameGenerator;
import net.morimekta.providence.testing.generator.extra.EnumValueGenerator;
import net.morimekta.providence.testing.generator.extra.IntRangeGenerator;
import net.morimekta.providence.testing.generator.extra.LongRangeGenerator;
import net.morimekta.providence.testing.generator.extra.OneOfGenerator;
import net.morimekta.providence.testing.generator.extra.ShortRangeGenerator;

public class ExtraGenerators {
    public static <Context extends GeneratorContext<Context>> ByteRangeGenerator<Context> byteRange(int fromIncluding, int toExcluding) {
        if (fromIncluding < -128 || fromIncluding > 127) {
            throw new AssertionError((Object)("Bad byte value, from: " + fromIncluding));
        }
        if (toExcluding < -128 || toExcluding > 127) {
            throw new AssertionError((Object)("Bad byte value, to: " + toExcluding));
        }
        return ExtraGenerators.byteRange((byte)fromIncluding, (byte)toExcluding);
    }

    public static <Context extends GeneratorContext<Context>> ByteRangeGenerator<Context> byteRange(byte fromIncluding, byte toExcluding) {
        return new ByteRangeGenerator(fromIncluding, toExcluding);
    }

    public static <Context extends GeneratorContext<Context>> ShortRangeGenerator<Context> shortRange(int fromIncluding, int toExcluding) {
        if (fromIncluding < Short.MIN_VALUE || fromIncluding > Short.MAX_VALUE) {
            throw new AssertionError((Object)("Bad short value, from: " + fromIncluding));
        }
        if (toExcluding < Short.MIN_VALUE || toExcluding > Short.MAX_VALUE) {
            throw new AssertionError((Object)("Bad short value, to: " + toExcluding));
        }
        return ExtraGenerators.shortRange((short)fromIncluding, (short)toExcluding);
    }

    public static <Context extends GeneratorContext<Context>> ShortRangeGenerator<Context> shortRange(short fromIncluding, short toExcluding) {
        return new ShortRangeGenerator(fromIncluding, toExcluding);
    }

    public static <Context extends GeneratorContext<Context>> IntRangeGenerator<Context> intRange(int fromIncluding, int toExcluding) {
        return new IntRangeGenerator(fromIncluding, toExcluding);
    }

    public static <Context extends GeneratorContext<Context>> LongRangeGenerator<Context> longRange(long fromIncluding, long toExcluding) {
        return new LongRangeGenerator(fromIncluding, toExcluding);
    }

    public static <Context extends GeneratorContext<Context>> DoubleRangeGenerator<Context> doubleRange(double fromIncluding, double toExcluding) {
        return new DoubleRangeGenerator(fromIncluding, toExcluding);
    }

    @SafeVarargs
    public static <Context extends GeneratorContext<Context>, T> OneOfGenerator<Context, T> oneOf(T ... selection) {
        return new OneOfGenerator(selection);
    }

    public static <Context extends GeneratorContext<Context>, T> OneOfGenerator<Context, T> oneOf(Collection<T> selection) {
        return new OneOfGenerator(selection);
    }

    @SafeVarargs
    public static <Context extends GeneratorContext<Context>, E extends PEnumValue<E>> EnumValueGenerator<Context, E> enumValue(E ... selection) {
        return new EnumValueGenerator(selection);
    }

    public static <Context extends GeneratorContext<Context>, E extends PEnumValue<E>> EnumValueGenerator<Context, E> enumValue(PEnumDescriptor<E> descriptor) {
        return new EnumValueGenerator(descriptor);
    }

    @SafeVarargs
    public static <Context extends GeneratorContext<Context>, E extends PEnumValue<E>> EnumNameGenerator<Context, E> enumName(E ... selection) {
        return new EnumNameGenerator(selection);
    }

    public static <Context extends GeneratorContext<Context>, E extends PEnumValue<E>> EnumNameGenerator<Context, E> enumName(PEnumDescriptor<E> descriptor) {
        return new EnumNameGenerator(descriptor);
    }

    private ExtraGenerators() {
    }
}

