/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.testing.generator.Generator;
import net.morimekta.providence.testing.generator.GeneratorContext;

public class MessageGenerator<Context extends GeneratorContext<Context>, Message extends PMessage<Message, Field>, Field extends PField>
implements Generator<Context, Message> {
    private final PMessageDescriptor<Message, Field> descriptor;
    private final Map<Field, Generator<Context, ?>> fieldValueGenerators;
    private final Map<Field, Boolean> fieldPresenceOverrides;

    public MessageGenerator(PMessageDescriptor<Message, Field> descriptor) {
        this(descriptor, new HashMap(), new HashMap());
    }

    private MessageGenerator(PMessageDescriptor<Message, Field> descriptor, Map<Field, Generator<Context, ?>> fieldValueGenerators, Map<Field, Boolean> fieldPresenceOverrides) {
        this.descriptor = descriptor;
        this.fieldValueGenerators = fieldValueGenerators;
        this.fieldPresenceOverrides = fieldPresenceOverrides;
    }

    @SafeVarargs
    public final MessageGenerator<Context, Message, Field> setAlwaysPresent(Field ... fields) {
        return this.setAlwaysPresent((Collection<Field>)Arrays.asList(fields));
    }

    public MessageGenerator<Context, Message, Field> setAlwaysPresent(@Nonnull Collection<Field> fields) {
        for (PField field : fields) {
            this.fieldPresenceOverrides.put(field, Boolean.TRUE);
        }
        return this;
    }

    @SafeVarargs
    public final MessageGenerator<Context, Message, Field> setAlwaysAbsent(Field ... fields) {
        return this.setAlwaysAbsent((Collection<Field>)Arrays.asList(fields));
    }

    public MessageGenerator<Context, Message, Field> setAlwaysAbsent(@Nonnull Collection<Field> fields) {
        for (PField field : fields) {
            this.fieldPresenceOverrides.put(field, Boolean.FALSE);
        }
        return this;
    }

    @SafeVarargs
    public final MessageGenerator<Context, Message, Field> setDefaultPresence(Field ... fields) {
        return this.setDefaultPresence((Collection<Field>)Arrays.asList(fields));
    }

    public MessageGenerator<Context, Message, Field> setDefaultPresence(@Nonnull Collection<Field> fields) {
        for (PField field : fields) {
            this.fieldPresenceOverrides.remove(field);
        }
        return this;
    }

    public MessageGenerator<Context, Message, Field> resetDefaultPresence() {
        this.fieldPresenceOverrides.clear();
        return this;
    }

    public MessageGenerator<Context, Message, Field> setValueGenerator(Field field, Generator<Context, ?> generator) {
        this.fieldValueGenerators.put(field, generator);
        return this;
    }

    @Override
    public Message generate(Context options) {
        PMessageBuilder builder = this.descriptor.builder();
        if (this.descriptor.getVariant() == PMessageVariant.UNION) {
            PField selectedField = null;
            HashSet<Field> blockedFields = new HashSet<Field>();
            for (Map.Entry<Field, Boolean> entry : this.fieldPresenceOverrides.entrySet()) {
                if (entry.getValue().booleanValue()) {
                    if (selectedField != null) {
                        throw new IllegalStateException("More than one required union field");
                    }
                    selectedField = (PField)entry.getKey();
                    continue;
                }
                blockedFields.add(entry.getKey());
            }
            if (selectedField == null) {
                ArrayList<PField> allowed = new ArrayList<PField>(Arrays.asList(this.descriptor.getFields()));
                allowed.removeAll(blockedFields);
                if (allowed.size() < 1) {
                    throw new IllegalStateException("No remaining fields allowed after " + blockedFields.size() + " was blocked");
                }
                int idx = ((GeneratorContext)options).getRandom().nextInt(allowed.size());
                selectedField = allowed.get(idx);
            }
            builder.set(selectedField, this.makeFieldValue(selectedField, options));
        } else {
            for (PField field : this.descriptor.getFields()) {
                if (this.fieldPresenceOverrides.containsKey(field)) {
                    if (!this.fieldPresenceOverrides.get(field).booleanValue()) continue;
                    builder.set(field, this.makeFieldValue(field, options));
                    continue;
                }
                if (field.getRequirement() != PRequirement.REQUIRED && ((GeneratorContext)options).getDefaultFillRate() < 1.0) {
                    if (!(((GeneratorContext)options).getRandom().nextDouble() < ((GeneratorContext)options).getDefaultFillRate())) continue;
                    builder.set(field, this.makeFieldValue(field, options));
                    continue;
                }
                builder.set(field, this.makeFieldValue(field, options));
            }
        }
        return (Message)((PMessage)builder.build());
    }

    protected MessageGenerator<Context, Message, Field> deepCopy() {
        return new MessageGenerator<Context, Message, Field>(this.descriptor, new HashMap(this.fieldValueGenerators), new HashMap<Field, Boolean>(this.fieldPresenceOverrides));
    }

    private Object makeFieldValue(Field field, Context context) {
        Generator<Context, Object> generator = this.fieldValueGenerators.get(field);
        if (generator == null) {
            generator = ((GeneratorContext)context).generatorFor(field.getDescriptor());
        }
        return generator.generate(context);
    }
}

