/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.generator.extra;

import net.morimekta.providence.testing.generator.Generator;
import net.morimekta.providence.testing.generator.GeneratorContext;

public class ByteRangeGenerator<Context extends GeneratorContext<Context>>
implements Generator<Context, Byte> {
    private final byte fromIncluding;
    private final byte toExcluding;

    public ByteRangeGenerator(byte fromIncluding, byte toExcluding) {
        this.fromIncluding = fromIncluding;
        this.toExcluding = toExcluding;
        if (fromIncluding >= toExcluding) {
            throw new AssertionError((Object)("Invalid range [ " + fromIncluding + " .. " + toExcluding + " >"));
        }
    }

    @Override
    public Byte generate(Context ctx) {
        return (byte)(this.fromIncluding + Math.abs(((GeneratorContext)ctx).getRandom().nextInt(this.toExcluding - this.fromIncluding)));
    }
}

