/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.generator;

import io.codearte.jfairy.Fairy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.testing.generator.Generator;
import net.morimekta.providence.testing.generator.GeneratorContext;
import net.morimekta.providence.testing.generator.MessageGenerator;
import net.morimekta.providence.testing.generator.defaults.BinaryGenerator;
import net.morimekta.providence.testing.generator.defaults.BoolGenerator;
import net.morimekta.providence.testing.generator.defaults.ByteGenerator;
import net.morimekta.providence.testing.generator.defaults.DoubleGenerator;
import net.morimekta.providence.testing.generator.defaults.EnumGenerator;
import net.morimekta.providence.testing.generator.defaults.IntGenerator;
import net.morimekta.providence.testing.generator.defaults.ListGenerator;
import net.morimekta.providence.testing.generator.defaults.LongGenerator;
import net.morimekta.providence.testing.generator.defaults.MapGenerator;
import net.morimekta.providence.testing.generator.defaults.SetGenerator;
import net.morimekta.providence.testing.generator.defaults.ShortGenerator;
import net.morimekta.providence.testing.generator.defaults.StringGenerator;

public abstract class GeneratorBase<Base extends GeneratorBase<Base, Context>, Context extends GeneratorContext<Context>> {
    private static final Fairy DEFAULT_FAIRY = Fairy.create((Locale)Locale.ENGLISH);
    private final Map<PMessageDescriptor, MessageGenerator> defaultMessageGenerators;
    private final Map<PEnumDescriptor, Generator> defaultEnumGenerators;
    private final EnumMap<PType, Generator<Context, ?>> primitiveCache;
    private Fairy fairy;
    private Random random;
    private double defaultFillRate;
    private int defaultMaxCollectionSize;

    public GeneratorBase() {
        this(DEFAULT_FAIRY, new Random());
    }

    public GeneratorBase(Fairy fairy, Random random) {
        this(fairy, random, 1.0, 10);
    }

    public GeneratorBase(Fairy fairy, Random random, double defaultFillRate, int defaultMaxCollectionSize) {
        this(new HashMap<PMessageDescriptor, MessageGenerator>(), new HashMap<PEnumDescriptor, Generator>(), defaultFillRate, defaultMaxCollectionSize, fairy, random);
    }

    private GeneratorBase(Map<PMessageDescriptor, MessageGenerator> defaultMessageGenerators, Map<PEnumDescriptor, Generator> defaultEnumGenerators, double defaultFillRate, int defaultMaxCollectionSize, Fairy fairy, Random random) {
        this.fairy = fairy;
        this.random = random;
        this.primitiveCache = new EnumMap(PType.class);
        this.defaultFillRate = defaultFillRate;
        this.defaultMaxCollectionSize = defaultMaxCollectionSize;
        this.defaultMessageGenerators = defaultMessageGenerators;
        this.defaultEnumGenerators = defaultEnumGenerators;
    }

    public abstract Context createContext();

    public GeneratorBase(GeneratorBase<Base, Context> copyOf) {
        this(new HashMap<PMessageDescriptor, MessageGenerator>(), new HashMap<PEnumDescriptor, Generator>(), copyOf.defaultFillRate, copyOf.defaultMaxCollectionSize, copyOf.fairy, copyOf.random);
        for (Map.Entry<PMessageDescriptor, MessageGenerator> entry : copyOf.defaultMessageGenerators.entrySet()) {
            this.defaultMessageGenerators.put(entry.getKey(), entry.getValue().deepCopy());
        }
        for (Map.Entry entry : copyOf.defaultEnumGenerators.entrySet()) {
            this.defaultEnumGenerators.put((PEnumDescriptor)entry.getKey(), entry.getValue());
        }
    }

    @Nonnull
    public <T> Generator<Context, T> generatorFor(@Nonnull PDescriptor type) {
        if (type instanceof PMessageDescriptor) {
            return this.messageGeneratorFor((PMessageDescriptor)type);
        }
        if (type instanceof PEnumDescriptor) {
            return this.enumGeneratorFor((PEnumDescriptor)type);
        }
        if (type instanceof PPrimitive) {
            if (!this.primitiveCache.containsKey(type.getType())) {
                this.primitiveCache.put(type.getType(), this.makeGeneratorInternal(type));
            }
            return this.primitiveCache.get(type.getType());
        }
        return this.makeGeneratorInternal(type);
    }

    @Nonnull
    public <E extends PEnumValue<E>> Generator<Context, E> enumGeneratorFor(PEnumDescriptor<E> descriptor) {
        EnumGenerator generator = this.defaultEnumGenerators.get(descriptor);
        if (generator == null) {
            generator = new EnumGenerator(descriptor);
            this.defaultEnumGenerators.put(descriptor, generator);
        }
        return generator;
    }

    @Nonnull
    public <M extends PMessage<M, F>, F extends PField> MessageGenerator<Context, M, F> messageGeneratorFor(PMessageDescriptor<M, F> descriptor) {
        MessageGenerator generator = this.defaultMessageGenerators.get(descriptor);
        if (generator == null) {
            generator = new MessageGenerator(descriptor);
            this.defaultMessageGenerators.put(descriptor, generator);
        }
        return generator;
    }

    @Nonnull
    public <E extends PEnumValue<E>> Base withEnumGenerator(PEnumDescriptor<E> descriptor, Generator<Context, E> generator) {
        this.defaultEnumGenerators.put(descriptor, generator);
        return this.self();
    }

    @Nonnull
    public <M extends PMessage<M, F>, F extends PField> Base withMessageGenerator(PMessageDescriptor<M, F> descriptor, MessageGenerator<Context, M, F> generator) {
        this.defaultMessageGenerators.put(descriptor, generator);
        return this.self();
    }

    @Nonnull
    public <M extends PMessage<M, F>, F extends PField> Base withMessageGenerator(PMessageDescriptor<M, F> descriptor, Consumer<MessageGenerator<Context, M, F>> closure) {
        closure.accept(this.messageGeneratorFor(descriptor));
        return this.self();
    }

    @Nonnull
    public Fairy getFairy() {
        return this.fairy;
    }

    @Nonnull
    public Base setFairy(Fairy fairy) {
        this.fairy = fairy;
        return this.self();
    }

    @Nonnull
    public Random getRandom() {
        return this.random;
    }

    @Nonnull
    public Base setRandom(Random random) {
        this.random = random;
        return this.self();
    }

    public int getDefaultMaxCollectionSize() {
        return this.defaultMaxCollectionSize;
    }

    @Nonnull
    public Base setDefaultMaxCollectionSize(int defaultMaxCollectionSize) {
        this.defaultMaxCollectionSize = defaultMaxCollectionSize;
        return this.self();
    }

    public double getDefaultFillRate() {
        return this.defaultFillRate;
    }

    @Nonnull
    public Base setDefaultFillRate(double defaultFillRate) {
        this.defaultFillRate = defaultFillRate;
        return this.self();
    }

    protected Base deepCopy() {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(this.getClass());
            return (Base)((GeneratorBase)constructor.newInstance(this));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    @Nonnull
    private Base self() {
        return (Base)this;
    }

    @Nonnull
    private <T> Generator<Context, T> makeGeneratorInternal(@Nonnull PDescriptor type) {
        switch (type.getType()) {
            case VOID: {
                return ctx -> Boolean.TRUE;
            }
            case BOOL: {
                return new BoolGenerator();
            }
            case BYTE: {
                return new ByteGenerator();
            }
            case I16: {
                return new ShortGenerator();
            }
            case I32: {
                return new IntGenerator();
            }
            case I64: {
                return new LongGenerator();
            }
            case DOUBLE: {
                return new DoubleGenerator();
            }
            case STRING: {
                return new StringGenerator();
            }
            case BINARY: {
                return new BinaryGenerator();
            }
            case LIST: {
                return new ListGenerator((PList<Object>)((PList)type));
            }
            case SET: {
                return new SetGenerator((PSet<Object>)((PSet)type));
            }
            case MAP: {
                return new MapGenerator((PMap<Object, Object>)((PMap)type));
            }
            case ENUM: {
                return this.enumGeneratorFor((PEnumDescriptor)type);
            }
            case MESSAGE: {
                return this.messageGeneratorFor((PMessageDescriptor)type);
            }
        }
        throw new IllegalArgumentException("Unhandled default type: " + type.getType());
    }
}

