/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.generator.extra;

import net.morimekta.providence.testing.generator.Generator;
import net.morimekta.providence.testing.generator.GeneratorContext;

public class IntRangeGenerator<Context extends GeneratorContext<Context>>
implements Generator<Context, Integer> {
    private final int fromIncluding;
    private final int toExcluding;

    public IntRangeGenerator(int fromIncluding, int toExcluding) {
        this.fromIncluding = fromIncluding;
        this.toExcluding = toExcluding;
        if (fromIncluding >= toExcluding) {
            throw new AssertionError((Object)("Invalid range [ " + fromIncluding + " .. " + toExcluding + " >"));
        }
    }

    @Override
    public Integer generate(Context ctx) {
        return this.fromIncluding + Math.abs(((GeneratorContext)ctx).getRandom().nextInt(this.toExcluding - this.fromIncluding));
    }
}

