/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.generator.extra;

import net.morimekta.providence.testing.generator.Generator;
import net.morimekta.providence.testing.generator.GeneratorContext;

public class LongRangeGenerator<Context extends GeneratorContext<Context>>
implements Generator<Context, Long> {
    private final long fromIncluding;
    private final long toExcluding;

    public LongRangeGenerator(long fromIncluding, long toExcluding) {
        this.fromIncluding = fromIncluding;
        this.toExcluding = toExcluding;
        if (fromIncluding >= toExcluding) {
            throw new AssertionError((Object)("Invalid range [ " + fromIncluding + " .. " + toExcluding + " >"));
        }
    }

    @Override
    public Long generate(Context ctx) {
        return this.fromIncluding + Math.abs(((GeneratorContext)ctx).getRandom().nextLong() % (this.toExcluding - this.fromIncluding));
    }
}

