/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.generator;

import io.codearte.jfairy.Fairy;
import java.util.Random;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.testing.generator.Generator;
import net.morimekta.providence.testing.generator.GeneratorBase;

public abstract class GeneratorContext<Context extends GeneratorContext<Context>> {
    private final GeneratorBase base;

    protected GeneratorContext(GeneratorBase base) {
        this.base = base;
    }

    @Nonnull
    public Fairy getFairy() {
        return this.base.getFairy();
    }

    @Nonnull
    public Random getRandom() {
        return this.base.getRandom();
    }

    public int getDefaultMaxCollectionSize() {
        return this.base.getDefaultMaxCollectionSize();
    }

    public double getDefaultFillRate() {
        return this.base.getDefaultFillRate();
    }

    public <T> Generator<Context, T> generatorFor(@Nonnull PDeclaredDescriptor<T> descriptor) {
        return this.base.generatorFor((PDescriptor)descriptor);
    }

    public <T> Generator<Context, T> generatorFor(@Nonnull PDescriptor descriptor) {
        return this.base.generatorFor(descriptor);
    }

    public int nextDefaultCollectionSize() {
        return this.getRandom().nextInt(this.getDefaultMaxCollectionSize());
    }
}

