/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.generator.extra;

import net.morimekta.providence.testing.generator.Generator;
import net.morimekta.providence.testing.generator.GeneratorContext;

public class ShortRangeGenerator<Context extends GeneratorContext<Context>>
implements Generator<Context, Short> {
    private final short fromIncluding;
    private final short toExcluding;

    public ShortRangeGenerator(short fromIncluding, short toExcluding) {
        this.fromIncluding = fromIncluding;
        this.toExcluding = toExcluding;
        if (fromIncluding >= toExcluding) {
            throw new AssertionError((Object)("Invalid range [ " + fromIncluding + " .. " + toExcluding + " >"));
        }
    }

    @Override
    public Short generate(Context ctx) {
        return (short)(this.fromIncluding + Math.abs(((GeneratorContext)ctx).getRandom().nextInt() % (this.toExcluding - this.fromIncluding)));
    }
}

