/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.generator;

import com.google.common.collect.ImmutableList;
import io.codearte.jfairy.Fairy;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Consumer;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.mio.IOMessageReader;
import net.morimekta.providence.mio.IOMessageWriter;
import net.morimekta.providence.mio.MessageReader;
import net.morimekta.providence.mio.MessageWriter;
import net.morimekta.providence.serializer.PrettySerializer;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.testing.generator.GeneratorBase;
import net.morimekta.providence.testing.generator.GeneratorContext;
import net.morimekta.providence.testing.generator.MessageGenerator;
import net.morimekta.providence.testing.generator.SimpleGeneratorWatcher;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class GeneratorWatcher<Base extends GeneratorBase<Base, Context>, Context extends GeneratorContext<Context>>
extends TestWatcher {
    private Serializer globalOutputSerializer;
    private boolean globalDumpOnFailure;
    private MessageWriter globalWriter;
    private MessageReader globalReader;
    private Base globalBase;
    private Serializer outputSerializer;
    private boolean dumpOnFailure;
    private MessageWriter writer;
    private MessageReader reader;
    private Base base;
    private List<PMessage> generated;
    private boolean started;

    public static SimpleGeneratorWatcher create() {
        return SimpleGeneratorWatcher.create();
    }

    public static <Context extends GeneratorContext<Context>, Base extends GeneratorBase<Base, Context>> GeneratorWatcher<Base, Context> create(Base base) {
        return new GeneratorWatcher<Base, Context>(base);
    }

    public GeneratorWatcher(Base base) {
        this.globalOutputSerializer = this.outputSerializer = new PrettySerializer().config();
        this.dumpOnFailure = false;
        this.globalDumpOnFailure = false;
        this.reader = null;
        this.globalReader = null;
        this.writer = null;
        this.globalWriter = null;
        this.base = base;
        this.globalBase = this.base;
        this.generated = new LinkedList<PMessage>();
        this.started = false;
    }

    public <M extends PMessage<M, F>, F extends PField> M generate(PMessageDescriptor<M, F> descriptor) {
        return this.generate(((GeneratorBase)this.base).createContext(), descriptor);
    }

    public <M extends PMessage<M, F>, F extends PField> M generate(Context context, PMessageDescriptor<M, F> descriptor) {
        Object instance;
        if (!this.started) {
            throw new IllegalStateException("Watcher is not started");
        }
        if (this.reader != null) {
            try {
                instance = this.reader.read(descriptor);
            }
            catch (IOException e) {
                throw new AssertionError(e.getMessage(), e);
            }
        } else {
            instance = ((GeneratorBase)this.base).messageGeneratorFor(descriptor).generate(context);
        }
        this.generated.add((PMessage)instance);
        return (M)instance;
    }

    public <M extends PMessage<M, F>, F extends PField> GeneratorWatcher<Base, Context> withGenerator(PMessageDescriptor<M, F> descriptor, Consumer<MessageGenerator<Context, M, F>> modificationConsumer) {
        modificationConsumer.accept(this.getDefaultGenerator(descriptor));
        return this;
    }

    public <M extends PMessage<M, F>, F extends PField> MessageGenerator<Context, M, F> getDefaultGenerator(PMessageDescriptor<M, F> descriptor) {
        return ((GeneratorBase)this.getBaseContext()).messageGeneratorFor(descriptor);
    }

    public <M extends PMessage<M, F>, F extends PField> MessageGenerator<Context, M, F> newReportingGenerator(PMessageDescriptor<M, F> descriptor) {
        return new MessageGenerator<Context, M, F>(descriptor){

            @Override
            public M generate(Context context) {
                Object message = super.generate(context);
                GeneratorWatcher.this.generated.add(message);
                return message;
            }
        };
    }

    public List<PMessage> allGenerated() {
        return ImmutableList.copyOf(this.generated);
    }

    public void dumpGeneratedMessages() throws IOException {
        MessageWriter writer = this.writer;
        if (writer == null) {
            writer = new IOMessageWriter((OutputStream)System.err, this.outputSerializer);
        }
        for (PMessage message : this.generated) {
            writer.write(message);
            writer.separator();
        }
    }

    public Base getBaseContext() {
        if (this.started) {
            return this.base;
        }
        return this.globalBase;
    }

    public GeneratorWatcher<Base, Context> setRandom(Random random) {
        ((GeneratorBase)this.getBaseContext()).setRandom(random);
        return this;
    }

    public GeneratorWatcher<Base, Context> setFairy(Fairy fairy) {
        ((GeneratorBase)this.getBaseContext()).setFairy(fairy);
        return this;
    }

    public GeneratorWatcher<Base, Context> setLocale(Locale locale) {
        return this.setFairy(Fairy.create((Locale)locale));
    }

    public GeneratorWatcher<Base, Context> setFillRate(double fillRate) {
        assert (fillRate > 0.0 && fillRate <= 1.0) : "Fill rate outside the range < 0.0 .. 1.0 ]: " + fillRate;
        ((GeneratorBase)this.getBaseContext()).setDefaultFillRate(fillRate);
        return this;
    }

    public GeneratorWatcher<Base, Context> setMessageWriter(MessageWriter writer) {
        if (this.started) {
            this.writer = writer;
        } else {
            this.globalWriter = writer;
            this.writer = writer;
        }
        return this;
    }

    public GeneratorWatcher<Base, Context> setMessageReader(MessageReader reader) {
        if (this.started) {
            this.reader = reader;
        } else {
            assert (this.globalReader == null) : "Generator already contains reader for messages.";
            this.globalReader = reader;
            this.reader = reader;
        }
        return this;
    }

    public GeneratorWatcher<Base, Context> setResourceReader(String resource) {
        return this.setResourceReader(resource, (Serializer)new PrettySerializer());
    }

    public GeneratorWatcher<Base, Context> setResourceReader(String resource, Serializer serializer) {
        return this.setMessageReader((MessageReader)new IOMessageReader(((Object)((Object)this)).getClass().getResourceAsStream(resource), serializer));
    }

    public GeneratorWatcher<Base, Context> setOutputSerializer(Serializer defaultSerializer) {
        if (this.started) {
            this.writer = null;
            this.outputSerializer = defaultSerializer;
        } else {
            assert (this.globalWriter == null) : "Generator already has a writer.";
            this.outputSerializer = defaultSerializer;
            this.globalOutputSerializer = defaultSerializer;
        }
        return this;
    }

    public GeneratorWatcher<Base, Context> setMaxCollectionItems(int max) {
        if (this.started) {
            ((GeneratorBase)this.base).setDefaultMaxCollectionSize(max);
        } else {
            ((GeneratorBase)this.globalBase).setDefaultMaxCollectionSize(max);
        }
        return this;
    }

    public GeneratorWatcher<Base, Context> dumpOnFailure() {
        if (this.started) {
            this.dumpOnFailure = true;
        } else {
            this.globalDumpOnFailure = true;
        }
        return this;
    }

    protected void starting(Description description) {
        super.starting(description);
        if (!description.isEmpty() && description.getMethodName() == null) {
            throw new AssertionError((Object)"MessageGenerator instantiated as class rule: forbidden");
        }
        this.writer = this.globalWriter;
        this.reader = this.globalReader;
        this.dumpOnFailure = this.globalDumpOnFailure;
        this.outputSerializer = this.globalOutputSerializer;
        this.base = ((GeneratorBase)this.globalBase).deepCopy();
        this.generated = new LinkedList<PMessage>();
        this.started = true;
    }

    protected void failed(Throwable e, Description description) {
        if (this.dumpOnFailure) {
            try {
                this.dumpGeneratedMessages();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                e.addSuppressed(e1);
            }
        }
    }

    protected void finished(Description description) {
        this.started = false;
        this.dumpOnFailure = this.globalDumpOnFailure;
        this.outputSerializer = this.globalOutputSerializer;
        this.writer = this.globalWriter;
        this.reader = this.globalReader;
        this.base = this.globalBase;
    }
}

