/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.util;

import com.google.common.collect.ImmutableList;
import io.codearte.jfairy.Fairy;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Supplier;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.mio.IOMessageReader;
import net.morimekta.providence.mio.IOMessageWriter;
import net.morimekta.providence.mio.MessageReader;
import net.morimekta.providence.mio.MessageWriter;
import net.morimekta.providence.serializer.PrettySerializer;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.util.Binary;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class MessageGenerator
extends TestWatcher {
    private final ValueSupplierFactory defaultFactory;
    private Random globalRandom;
    private Fairy globalFairy;
    private Serializer globalOutputSerializer;
    private int globalMaxCollectionItems;
    private boolean globalDumpOnFailure;
    private MessageWriter globalWriter;
    private MessageReader globalReader;
    private List<ValueSupplierFactory> globalFactories;
    private double globalFillRate;
    private Random random;
    private Fairy fairy;
    private Serializer outputSerializer;
    private int maxCollectionItems;
    private boolean dumpOnFailure;
    private MessageWriter writer;
    private MessageReader reader;
    private List<ValueSupplierFactory> factories;
    private double fillRate;
    private List<PMessage> generated;
    private boolean started;

    public MessageGenerator() {
        this.globalFairy = this.fairy = Fairy.create((Locale)Locale.ENGLISH);
        this.globalRandom = this.random = new Random();
        this.globalOutputSerializer = this.outputSerializer = new PrettySerializer().config();
        this.maxCollectionItems = 10;
        this.globalMaxCollectionItems = 10;
        this.factories = new LinkedList<ValueSupplierFactory>();
        this.globalFactories = this.factories;
        this.dumpOnFailure = false;
        this.globalDumpOnFailure = false;
        this.reader = null;
        this.globalReader = null;
        this.writer = null;
        this.globalWriter = null;
        this.fillRate = 1.0;
        this.globalFillRate = 1.0;
        this.defaultFactory = this::getDefaultValueSupplier;
        this.generated = new LinkedList<PMessage>();
        this.started = false;
    }

    public <M extends PMessage<M, F>, F extends PField> M generate(PMessageDescriptor<M, F> descriptor) {
        Object instance;
        if (this.reader != null) {
            try {
                instance = this.reader.read(descriptor);
            }
            catch (IOException e) {
                throw new AssertionError(e.getMessage(), e);
            }
        } else {
            instance = this.generateInternal(descriptor);
        }
        this.generated.add((PMessage)instance);
        return instance;
    }

    public List<PMessage> getGenerated() {
        return ImmutableList.copyOf(this.generated);
    }

    public void dumpGeneratedMessages() throws IOException {
        MessageWriter writer = this.writer;
        if (writer == null) {
            writer = new IOMessageWriter((OutputStream)System.err, this.outputSerializer);
        }
        for (PMessage message : this.generated) {
            writer.write(message);
            writer.separator();
        }
    }

    public MessageGenerator setRandom(Random random) {
        if (this.started) {
            this.random = random;
        } else {
            this.globalRandom = random;
            this.random = random;
        }
        return this;
    }

    public MessageGenerator setFairy(Fairy fairy) {
        if (this.started) {
            this.fairy = fairy;
        } else {
            this.globalFairy = fairy;
            this.fairy = fairy;
        }
        return this;
    }

    public MessageGenerator setLocale(Locale locale) {
        this.fairy = Fairy.create((Locale)locale);
        if (!this.started) {
            this.globalFairy = this.fairy;
        }
        return this;
    }

    public MessageGenerator setFillRate(double fillRate) {
        assert (fillRate > 0.0 && fillRate <= 1.0) : "Fill rate outside the range < 0.0 .. 1.0 ]: " + fillRate;
        if (this.started) {
            this.fillRate = fillRate;
        } else {
            this.globalFillRate = fillRate;
            this.fillRate = fillRate;
        }
        return this;
    }

    public MessageGenerator addFactory(ValueSupplierFactory factory) {
        if (this.started) {
            this.factories.add(factory);
        } else {
            this.globalFactories.add(factory);
        }
        return this;
    }

    public MessageGenerator addFactories(ValueSupplierFactory ... factories) {
        if (this.started) {
            Collections.addAll(this.factories, factories);
        } else {
            Collections.addAll(this.globalFactories, factories);
        }
        return this;
    }

    public MessageGenerator addFactories(Collection<ValueSupplierFactory> factories) {
        if (this.started) {
            this.factories.addAll(factories);
        } else {
            this.globalFactories.addAll(factories);
        }
        return this;
    }

    public MessageGenerator setMessageWriter(MessageWriter writer) {
        if (this.started) {
            this.writer = writer;
        } else {
            this.globalWriter = writer;
            this.writer = writer;
        }
        return this;
    }

    public MessageGenerator setMessageReader(MessageReader reader) {
        if (this.started) {
            this.reader = reader;
        } else {
            assert (this.globalReader == null) : "Generator already contains reader for messages.";
            this.globalReader = reader;
            this.reader = reader;
        }
        return this;
    }

    public MessageGenerator setResourceReader(String resource) {
        return this.setResourceReader(resource, (Serializer)new PrettySerializer());
    }

    public MessageGenerator setResourceReader(String resource, Serializer serializer) {
        return this.setMessageReader((MessageReader)new IOMessageReader(((Object)((Object)this)).getClass().getResourceAsStream(resource), serializer));
    }

    public MessageGenerator setOutputSerializer(Serializer defaultSerializer) {
        if (this.started) {
            this.writer = null;
            this.outputSerializer = defaultSerializer;
        } else {
            assert (this.globalWriter == null) : "Generator already has a writer.";
            this.outputSerializer = defaultSerializer;
            this.globalOutputSerializer = defaultSerializer;
        }
        return this;
    }

    public MessageGenerator setMaxCollectionItems(int max) {
        if (!this.started) {
            this.maxCollectionItems = max;
        } else {
            this.globalMaxCollectionItems = max;
            this.maxCollectionItems = max;
        }
        return this;
    }

    public MessageGenerator dumpOnFailure() {
        if (this.started) {
            this.dumpOnFailure = true;
        } else {
            this.globalDumpOnFailure = true;
            this.dumpOnFailure = true;
        }
        return this;
    }

    public Supplier<Object> getValueSupplier(PDescriptor descriptor) {
        switch (descriptor.getType()) {
            case BOOL: {
                return this.random::nextBoolean;
            }
            case BYTE: {
                return () -> (byte)this.random.nextInt();
            }
            case I16: {
                return () -> (short)this.random.nextInt();
            }
            case I32: {
                return this.random::nextInt;
            }
            case I64: {
                return this.random::nextLong;
            }
            case DOUBLE: {
                return this.random::nextDouble;
            }
            case ENUM: {
                PEnumDescriptor ed = (PEnumDescriptor)descriptor;
                PEnumValue[] values = ed.getValues();
                return () -> values[Math.abs(this.random.nextInt()) % values.length];
            }
            case BINARY: {
                return () -> {
                    byte[] tmp = new byte[this.nextCollectionSize()];
                    this.random.nextBytes(tmp);
                    return Binary.wrap((byte[])tmp);
                };
            }
            case STRING: {
                return () -> this.fairy.textProducer().sentence();
            }
            case SET: {
                PSet set = (PSet)descriptor;
                Supplier<Object> itemSupplier = this.getValueSupplier(set.itemDescriptor());
                return () -> {
                    int num = this.nextCollectionSize();
                    LinkedHashSet builder = new LinkedHashSet();
                    for (int i = 0; i < num; ++i) {
                        builder.add(itemSupplier.get());
                    }
                    return set.builder().addAll(builder).build();
                };
            }
            case LIST: {
                PList list = (PList)descriptor;
                Supplier<Object> itemSupplier = this.getValueSupplier(list.itemDescriptor());
                return () -> {
                    int num = this.nextCollectionSize();
                    PList.Builder builder = list.builder();
                    for (int i = 0; i < num; ++i) {
                        builder.add(itemSupplier.get());
                    }
                    return builder.build();
                };
            }
            case MAP: {
                PMap map = (PMap)descriptor;
                Supplier<Object> keySupplier = this.getValueSupplier(map.keyDescriptor());
                Supplier<Object> itemSupplier = this.getValueSupplier(map.itemDescriptor());
                return () -> {
                    int num = this.nextCollectionSize();
                    LinkedHashMap builder = new LinkedHashMap();
                    for (int i = 0; i < num; ++i) {
                        builder.put(keySupplier.get(), itemSupplier.get());
                    }
                    return map.builder().putAll(builder).build();
                };
            }
            case MESSAGE: {
                return () -> this.generateInternal((PMessageDescriptor)descriptor);
            }
            case VOID: {
                return () -> Boolean.TRUE;
            }
        }
        throw new IllegalArgumentException(descriptor.getType() + " field in message");
    }

    protected void starting(Description description) {
        super.starting(description);
        if (!description.isEmpty() && description.getMethodName() == null) {
            throw new AssertionError((Object)"MessageGenerator instantiated as class rule: forbidden");
        }
        this.random = this.globalRandom;
        this.fairy = this.globalFairy;
        this.writer = this.globalWriter;
        this.reader = this.globalReader;
        this.factories = new LinkedList<ValueSupplierFactory>(this.globalFactories);
        this.dumpOnFailure = this.globalDumpOnFailure;
        this.outputSerializer = this.globalOutputSerializer;
        this.maxCollectionItems = this.globalMaxCollectionItems;
        this.fillRate = this.globalFillRate;
        this.generated = new LinkedList<PMessage>();
        this.started = true;
    }

    protected void failed(Throwable e, Description description) {
        if (this.dumpOnFailure) {
            try {
                this.dumpGeneratedMessages();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                e.addSuppressed(e1);
            }
        }
    }

    protected void finished(Description description) {
        this.started = false;
        this.dumpOnFailure = this.globalDumpOnFailure;
        this.maxCollectionItems = this.globalMaxCollectionItems;
        this.outputSerializer = this.globalOutputSerializer;
        this.factories = this.globalFactories;
        this.fairy = this.globalFairy;
        this.random = this.globalRandom;
        this.writer = this.globalWriter;
        this.reader = this.globalReader;
        this.fillRate = this.globalFillRate;
    }

    private int nextCollectionSize() {
        return Math.abs(this.random.nextInt() % this.maxCollectionItems);
    }

    private Supplier<Object> getValueSupplier(PField field) {
        for (ValueSupplierFactory factory : this.factories) {
            Supplier<Object> supplier = factory.get(field);
            if (supplier == null) continue;
            return supplier;
        }
        return this.defaultFactory.get(field);
    }

    private Supplier<Object> getDefaultValueSupplier(PField field) {
        if (field.getRequirement() != PRequirement.REQUIRED && this.fillRate < 1.0 && this.random.nextDouble() < this.fillRate) {
            return () -> null;
        }
        return this.getValueSupplier(field.getDescriptor());
    }

    private <M extends PMessage<M, F>, F extends PField> M generateInternal(PMessageDescriptor<M, F> descriptor) {
        PMessageBuilder builder = descriptor.builder();
        if (descriptor.getVariant() == PMessageVariant.UNION) {
            PField field = descriptor.getFields()[this.random.nextInt(descriptor.getFields().length)];
            Supplier<Object> supplier = this.getValueSupplier(field);
            Assert.assertNotNull((String)("No supplier for field: " + descriptor.getQualifiedName() + "." + field.getName()), supplier);
            Object value = supplier.get();
            if (value != null) {
                builder.set(field, value);
            }
        } else {
            for (PField field : descriptor.getFields()) {
                Supplier<Object> supplier = this.getValueSupplier(field);
                Assert.assertNotNull((String)("No supplier for field: " + descriptor.getQualifiedName() + "." + field.getName()), supplier);
                Object value = supplier.get();
                if (value == null) continue;
                builder.set(field, value);
            }
        }
        return (M)((PMessage)builder.build());
    }

    @FunctionalInterface
    public static interface ValueSupplierFactory {
        public Supplier<Object> get(PField var1);
    }
}

