/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.morimekta.util.io.IOUtils;
import org.junit.Assert;

public class ResourceUtils {
    public static File copyResourceTo(String resource, File dir) {
        if (!dir.exists()) {
            Assert.fail((String)("Trying to copy resource " + resource + " to non-existing directory: " + dir));
        }
        if (dir.isFile()) {
            Assert.fail((String)("Trying to copy resource " + resource + " to file: " + dir + ", directory required"));
        }
        int i = resource.lastIndexOf(47);
        File file = new File(dir, resource.substring(i + 1));
        try (FileOutputStream out = new FileOutputStream(file);
             BufferedInputStream in = ResourceUtils.getResourceAsStream(resource);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return file;
    }

    public static void writeContentTo(String content, File target) {
        try (FileOutputStream fos = new FileOutputStream(target);
             BufferedOutputStream out = new BufferedOutputStream(fos);){
            out.write(content.getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static BufferedInputStream getResourceAsStream(String resource) {
        InputStream in = ResourceUtils.class.getResourceAsStream(resource);
        Assert.assertNotNull((String)("Trying to read non-existing resource " + resource), (Object)in);
        return new BufferedInputStream(in);
    }

    public static byte[] getResourceAsBytes(String resource) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (BufferedInputStream in = ResourceUtils.getResourceAsStream(resource);){
            IOUtils.copy((InputStream)in, (OutputStream)baos);
        }
        catch (IOException e) {
            Assert.fail((String)("Failed to read resource " + resource + ": " + e.getMessage()));
        }
        return baos.toByteArray();
    }

    public static ByteBuffer getResourceAsByteBuffer(String resource) {
        return ByteBuffer.wrap(ResourceUtils.getResourceAsBytes(resource));
    }

    public static String getResourceAsString(String resource) {
        return new String(ResourceUtils.getResourceAsBytes(resource), StandardCharsets.UTF_8).replaceAll("\\r", "");
    }

    private ResourceUtils() {
    }
}

