/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing;

import java.util.LinkedList;
import junit.framework.TestCase;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.util.Strings;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class HasFieldValueThat<Message extends PMessage<Message, Field>, Field extends PField, MT>
extends BaseMatcher<Message> {
    private final String[] path;
    private final Matcher<MT> valueMatcher;

    public HasFieldValueThat(String path, Matcher<MT> valueMatcher) {
        this.path = path.split("[.]");
        this.valueMatcher = valueMatcher;
        TestCase.assertTrue((String)"Field path has content", (this.path.length > 0 ? 1 : 0) != 0);
    }

    public HasFieldValueThat(Field field, Matcher<MT> valueMatcher) {
        this.path = new String[]{field.getName()};
        this.valueMatcher = valueMatcher;
    }

    public boolean matches(Object o) {
        if (o == null) {
            return false;
        }
        for (int i = 0; i < this.path.length; ++i) {
            if (!(o instanceof PMessage)) {
                return false;
            }
            PMessage actual = (PMessage)o;
            PField field = actual.descriptor().getField(this.path[i]);
            if (field == null) {
                return false;
            }
            if (!actual.has(field.getKey())) {
                return false;
            }
            o = actual.get(field.getKey());
        }
        return this.valueMatcher.matches(o);
    }

    public void describeTo(Description description) {
        description.appendText("has field '" + Strings.join((String)".", (Object[])this.path) + "' that ");
        this.valueMatcher.describeTo(description);
    }

    public void describeMismatch(Object o, Description mismatchDescription) {
        if (o == null) {
            mismatchDescription.appendText("got null message");
        } else {
            if (!(o instanceof PMessage)) {
                mismatchDescription.appendText("instance is not a message");
                return;
            }
            LinkedList<String> stack = new LinkedList<String>();
            String path = "";
            for (int i = 0; i < this.path.length; ++i) {
                String fieldName = this.path[i];
                stack.add(fieldName);
                path = Strings.join((String)".", stack);
                if (!(o instanceof PMessage)) {
                    mismatchDescription.appendText("field " + path + " is not a message");
                    return;
                }
                PMessage actual = (PMessage)o;
                PField field = actual.descriptor().getField(fieldName);
                if (field == null) {
                    mismatchDescription.appendText("field path " + path + " is not valid");
                    return;
                }
                if (!actual.has(field.getKey())) {
                    mismatchDescription.appendText("field " + path + " is missing");
                    return;
                }
                o = actual.get(field.getKey());
            }
            mismatchDescription.appendText("field " + path + " ");
            this.valueMatcher.describeMismatch(o, mismatchDescription);
        }
    }
}

