/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.model.Declaration;
import net.morimekta.util.Strings;

public class ThriftDocument
implements PMessage<ThriftDocument>,
Serializable,
Comparable<ThriftDocument> {
    private static final long serialVersionUID = -5731994850994905187L;
    private final String mComment;
    private final String mPackage;
    private final List<String> mIncludes;
    private final Map<String, String> mNamespaces;
    private final List<Declaration> mDecl;
    private volatile int tHashCode;
    public static final PStructDescriptor<ThriftDocument, _Field> kDescriptor = new _Descriptor();

    private ThriftDocument(_Builder builder) {
        this.mComment = builder.mComment;
        this.mPackage = builder.mPackage;
        this.mIncludes = builder.isSetIncludes() ? builder.mIncludes.build() : null;
        this.mNamespaces = builder.isSetNamespaces() ? builder.mNamespaces.build() : null;
        this.mDecl = builder.isSetDecl() ? builder.mDecl.build() : null;
    }

    public ThriftDocument(String pComment, String pPackage, List<String> pIncludes, Map<String, String> pNamespaces, List<Declaration> pDecl) {
        this.mComment = pComment;
        this.mPackage = pPackage;
        this.mIncludes = pIncludes != null ? ImmutableList.copyOf(pIncludes) : null;
        this.mNamespaces = pNamespaces != null ? ImmutableMap.copyOf(pNamespaces) : null;
        this.mDecl = pDecl != null ? ImmutableList.copyOf(pDecl) : null;
    }

    public boolean hasComment() {
        return this.mComment != null;
    }

    public String getComment() {
        return this.mComment;
    }

    public boolean hasPackage() {
        return this.mPackage != null;
    }

    public String getPackage() {
        return this.mPackage;
    }

    public int numIncludes() {
        return this.mIncludes != null ? this.mIncludes.size() : 0;
    }

    public boolean hasIncludes() {
        return this.mIncludes != null;
    }

    public List<String> getIncludes() {
        return this.mIncludes;
    }

    public int numNamespaces() {
        return this.mNamespaces != null ? this.mNamespaces.size() : 0;
    }

    public boolean hasNamespaces() {
        return this.mNamespaces != null;
    }

    public Map<String, String> getNamespaces() {
        return this.mNamespaces;
    }

    public int numDecl() {
        return this.mDecl != null ? this.mDecl.size() : 0;
    }

    public boolean hasDecl() {
        return this.mDecl != null;
    }

    public List<Declaration> getDecl() {
        return this.mDecl;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasComment();
            }
            case 2: {
                return this.hasPackage();
            }
            case 3: {
                return this.numIncludes() > 0;
            }
            case 4: {
                return this.numNamespaces() > 0;
            }
            case 5: {
                return this.numDecl() > 0;
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasComment() ? 1 : 0;
            }
            case 2: {
                return this.hasPackage() ? 1 : 0;
            }
            case 3: {
                return this.numIncludes();
            }
            case 4: {
                return this.numNamespaces();
            }
            case 5: {
                return this.numDecl();
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getComment();
            }
            case 2: {
                return this.getPackage();
            }
            case 3: {
                return this.getIncludes();
            }
            case 4: {
                return this.getNamespaces();
            }
            case 5: {
                return this.getDecl();
            }
        }
        return null;
    }

    public boolean compact() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ThriftDocument)) {
            return false;
        }
        ThriftDocument other = (ThriftDocument)o;
        return Objects.equals(this.mComment, other.mComment) && Objects.equals(this.mPackage, other.mPackage) && Objects.equals(this.mIncludes, other.mIncludes) && Objects.equals(this.mNamespaces, other.mNamespaces) && Objects.equals(this.mDecl, other.mDecl);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{ThriftDocument.class, _Field.COMMENT, this.mComment, _Field.PACKAGE, this.mPackage, _Field.INCLUDES, this.mIncludes, _Field.NAMESPACES, this.mNamespaces, _Field.DECL, this.mDecl});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "model.ThriftDocument" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.mComment != null) {
            first = false;
            out.append("comment:").append('\"').append(Strings.escape((CharSequence)this.mComment)).append('\"');
        }
        if (this.mPackage != null) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("package:").append('\"').append(Strings.escape((CharSequence)this.mPackage)).append('\"');
        }
        if (this.mIncludes != null && this.mIncludes.size() > 0) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("includes:").append(Strings.asString(this.mIncludes));
        }
        if (this.mNamespaces != null && this.mNamespaces.size() > 0) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("namespaces:").append(Strings.asString(this.mNamespaces));
        }
        if (this.mDecl != null && this.mDecl.size() > 0) {
            if (!first) {
                out.append(',');
            }
            out.append("decl:").append(Strings.asString(this.mDecl));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(ThriftDocument other) {
        int c = Boolean.compare(this.mComment != null, other.mComment != null);
        if (c != 0) {
            return c;
        }
        if (this.mComment != null && (c = this.mComment.compareTo(other.mComment)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mPackage != null, other.mPackage != null);
        if (c != 0) {
            return c;
        }
        if (this.mPackage != null && (c = this.mPackage.compareTo(other.mPackage)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mIncludes != null, other.mIncludes != null);
        if (c != 0) {
            return c;
        }
        if (this.mIncludes != null && (c = Integer.compare(this.mIncludes.hashCode(), other.mIncludes.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mNamespaces != null, other.mNamespaces != null);
        if (c != 0) {
            return c;
        }
        if (this.mNamespaces != null && (c = Integer.compare(this.mNamespaces.hashCode(), other.mNamespaces.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mDecl != null, other.mDecl != null);
        if (c != 0) {
            return c;
        }
        if (this.mDecl != null && (c = Integer.compare(this.mDecl.hashCode(), other.mDecl.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    public static PStructDescriptorProvider<ThriftDocument, _Field> provider() {
        return new _Provider();
    }

    public PStructDescriptor<ThriftDocument, _Field> descriptor() {
        return kDescriptor;
    }

    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<ThriftDocument> {
        private BitSet optionals = new BitSet(5);
        private String mComment;
        private String mPackage;
        private PList.Builder<String> mIncludes = new PList.ImmutableListBuilder();
        private PMap.Builder<String, String> mNamespaces = new PMap.ImmutableMapBuilder();
        private PList.Builder<Declaration> mDecl = new PList.ImmutableListBuilder();

        public _Builder() {
        }

        public _Builder(ThriftDocument base) {
            this();
            if (base.hasComment()) {
                this.optionals.set(0);
                this.mComment = base.mComment;
            }
            if (base.hasPackage()) {
                this.optionals.set(1);
                this.mPackage = base.mPackage;
            }
            if (base.numIncludes() > 0) {
                this.optionals.set(2);
                this.mIncludes.addAll((Collection)base.mIncludes);
            }
            if (base.numNamespaces() > 0) {
                this.optionals.set(3);
                this.mNamespaces.putAll(base.mNamespaces);
            }
            if (base.numDecl() > 0) {
                this.optionals.set(4);
                this.mDecl.addAll((Collection)base.mDecl);
            }
        }

        public _Builder setComment(String value) {
            this.optionals.set(0);
            this.mComment = value;
            return this;
        }

        public boolean isSetComment() {
            return this.optionals.get(0);
        }

        public _Builder clearComment() {
            this.optionals.clear(0);
            this.mComment = null;
            return this;
        }

        public _Builder setPackage(String value) {
            this.optionals.set(1);
            this.mPackage = value;
            return this;
        }

        public boolean isSetPackage() {
            return this.optionals.get(1);
        }

        public _Builder clearPackage() {
            this.optionals.clear(1);
            this.mPackage = null;
            return this;
        }

        public _Builder setIncludes(Collection<String> value) {
            this.optionals.set(2);
            this.mIncludes.clear();
            this.mIncludes.addAll(value);
            return this;
        }

        public _Builder addToIncludes(String ... values) {
            this.optionals.set(2);
            for (String item : values) {
                this.mIncludes.add((Object)item);
            }
            return this;
        }

        public boolean isSetIncludes() {
            return this.optionals.get(2);
        }

        public _Builder clearIncludes() {
            this.optionals.clear(2);
            this.mIncludes.clear();
            return this;
        }

        public _Builder setNamespaces(Map<String, String> value) {
            this.optionals.set(3);
            this.mNamespaces.clear();
            this.mNamespaces.putAll(value);
            return this;
        }

        public _Builder putInNamespaces(String key, String value) {
            this.optionals.set(3);
            this.mNamespaces.put((Object)key, (Object)value);
            return this;
        }

        public boolean isSetNamespaces() {
            return this.optionals.get(3);
        }

        public _Builder clearNamespaces() {
            this.optionals.clear(3);
            this.mNamespaces.clear();
            return this;
        }

        public _Builder setDecl(Collection<Declaration> value) {
            this.optionals.set(4);
            this.mDecl.clear();
            this.mDecl.addAll(value);
            return this;
        }

        public _Builder addToDecl(Declaration ... values) {
            this.optionals.set(4);
            for (Declaration item : values) {
                this.mDecl.add((Object)item);
            }
            return this;
        }

        public boolean isSetDecl() {
            return this.optionals.get(4);
        }

        public _Builder clearDecl() {
            this.optionals.clear(4);
            this.mDecl.clear();
            return this;
        }

        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setComment((String)value);
                    break;
                }
                case 2: {
                    this.setPackage((String)value);
                    break;
                }
                case 3: {
                    this.setIncludes((List)value);
                    break;
                }
                case 4: {
                    this.setNamespaces((Map)value);
                    break;
                }
                case 5: {
                    this.setDecl((List)value);
                }
            }
            return this;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 3: {
                    this.addToIncludes((String)value);
                    break;
                }
                case 5: {
                    this.addToDecl((Declaration)value);
                    break;
                }
            }
            return this;
        }

        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearComment();
                    break;
                }
                case 2: {
                    this.clearPackage();
                    break;
                }
                case 3: {
                    this.clearIncludes();
                    break;
                }
                case 4: {
                    this.clearNamespaces();
                    break;
                }
                case 5: {
                    this.clearDecl();
                }
            }
            return this;
        }

        public boolean isValid() {
            return this.optionals.get(1);
        }

        public ThriftDocument build() {
            return new ThriftDocument(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<ThriftDocument> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<ThriftDocument, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<ThriftDocument, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<ThriftDocument, _Field> {
        public _Descriptor() {
            super("model", "ThriftDocument", (PMessageBuilderFactory)new _Factory(), false, false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        COMMENT(1, PRequirement.DEFAULT, "comment", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        PACKAGE(2, PRequirement.REQUIRED, "package", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        INCLUDES(3, PRequirement.DEFAULT, "includes", (PDescriptorProvider)PList.provider((PDescriptorProvider)PPrimitive.STRING.provider()), null),
        NAMESPACES(4, PRequirement.DEFAULT, "namespaces", (PDescriptorProvider)PMap.provider((PDescriptorProvider)PPrimitive.STRING.provider(), (PDescriptorProvider)PPrimitive.STRING.provider()), null),
        DECL(5, PRequirement.DEFAULT, "decl", (PDescriptorProvider)PList.provider(Declaration.provider()), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PType getType() {
            return this.getDescriptor().getType();
        }

        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ThriftDocument._Field(").append(this.mKey).append(": ");
            if (this.mRequired != PRequirement.DEFAULT) {
                builder.append(this.mRequired.label).append(" ");
            }
            builder.append(this.getDescriptor().getQualifiedName(null)).append(' ').append(this.mName).append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return COMMENT;
                }
                case 2: {
                    return PACKAGE;
                }
                case 3: {
                    return INCLUDES;
                }
                case 4: {
                    return NAMESPACES;
                }
                case 5: {
                    return DECL;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "comment": {
                    return COMMENT;
                }
                case "package": {
                    return PACKAGE;
                }
                case "includes": {
                    return INCLUDES;
                }
                case "namespaces": {
                    return NAMESPACES;
                }
                case "decl": {
                    return DECL;
                }
            }
            return null;
        }
    }
}

