/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.model.ServiceMethod;
import net.morimekta.providence.util.TypeUtils;

public class ServiceType
implements PMessage<ServiceType>,
Serializable,
Comparable<ServiceType> {
    private static final long serialVersionUID = 789757775761432238L;
    private final String mComment;
    private final String mName;
    private final String mExtend;
    private final List<ServiceMethod> mMethods;
    private final Map<String, String> mAnnotations;
    private volatile int tHashCode;
    public static final PStructDescriptor<ServiceType, _Field> kDescriptor = new _Descriptor();

    private ServiceType(_Builder builder) {
        this.mComment = builder.mComment;
        this.mName = builder.mName;
        this.mExtend = builder.mExtend;
        this.mMethods = builder.isSetMethods() ? builder.mMethods.build() : null;
        this.mAnnotations = builder.isSetAnnotations() ? builder.mAnnotations.build() : null;
    }

    public ServiceType(String pComment, String pName, String pExtend, List<ServiceMethod> pMethods, Map<String, String> pAnnotations) {
        this.mComment = pComment;
        this.mName = pName;
        this.mExtend = pExtend;
        this.mMethods = pMethods != null ? ImmutableList.copyOf(pMethods) : null;
        this.mAnnotations = pAnnotations != null ? ImmutableMap.copyOf(pAnnotations) : null;
    }

    public boolean hasComment() {
        return this.mComment != null;
    }

    public String getComment() {
        return this.mComment;
    }

    public boolean hasName() {
        return this.mName != null;
    }

    public String getName() {
        return this.mName;
    }

    public boolean hasExtend() {
        return this.mExtend != null;
    }

    public String getExtend() {
        return this.mExtend;
    }

    public int numMethods() {
        return this.mMethods != null ? this.mMethods.size() : 0;
    }

    public List<ServiceMethod> getMethods() {
        return this.mMethods;
    }

    public int numAnnotations() {
        return this.mAnnotations != null ? this.mAnnotations.size() : 0;
    }

    public Map<String, String> getAnnotations() {
        return this.mAnnotations;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasComment();
            }
            case 2: {
                return this.hasName();
            }
            case 3: {
                return this.hasExtend();
            }
            case 4: {
                return this.numMethods() > 0;
            }
            case 5: {
                return this.numAnnotations() > 0;
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasComment() ? 1 : 0;
            }
            case 2: {
                return this.hasName() ? 1 : 0;
            }
            case 3: {
                return this.hasExtend() ? 1 : 0;
            }
            case 4: {
                return this.numMethods();
            }
            case 5: {
                return this.numAnnotations();
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getComment();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getExtend();
            }
            case 4: {
                return this.getMethods();
            }
            case 5: {
                return this.getAnnotations();
            }
        }
        return null;
    }

    public boolean compact() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ServiceType)) {
            return false;
        }
        ServiceType other = (ServiceType)o;
        return Objects.equals(this.mComment, other.mComment) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mExtend, other.mExtend) && TypeUtils.equals(this.mMethods, other.mMethods) && TypeUtils.equals(this.mAnnotations, other.mAnnotations);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{ServiceType.class, _Field.COMMENT, this.mComment, _Field.NAME, this.mName, _Field.EXTEND, this.mExtend, _Field.METHODS, TypeUtils.hashCode(this.mMethods), _Field.ANNOTATIONS, TypeUtils.hashCode(this.mAnnotations)});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "model.ServiceType" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasComment()) {
            first = false;
            out.append("comment:");
            out.append('\"').append(this.mComment).append('\"');
        }
        if (this.hasName()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("name:");
            out.append('\"').append(this.mName).append('\"');
        }
        if (this.hasExtend()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("extend:");
            out.append('\"').append(this.mExtend).append('\"');
        }
        if (this.numMethods() > 0) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("methods:");
            out.append(TypeUtils.toString(this.mMethods));
        }
        if (this.numAnnotations() > 0) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("annotations:");
            out.append(TypeUtils.toString(this.mAnnotations));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(ServiceType other) {
        int c = Boolean.compare(this.mComment != null, other.mComment != null);
        if (c != 0) {
            return c;
        }
        if (this.mComment != null && (c = this.mComment.compareTo(other.mComment)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mName != null, other.mName != null);
        if (c != 0) {
            return c;
        }
        if (this.mName != null && (c = this.mName.compareTo(other.mName)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mExtend != null, other.mExtend != null);
        if (c != 0) {
            return c;
        }
        if (this.mExtend != null && (c = this.mExtend.compareTo(other.mExtend)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mMethods != null, other.mMethods != null);
        if (c != 0) {
            return c;
        }
        if (this.mMethods != null && (c = Integer.compare(this.mMethods.hashCode(), other.mMethods.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mAnnotations != null, other.mAnnotations != null);
        if (c != 0) {
            return c;
        }
        if (this.mAnnotations != null && (c = Integer.compare(this.mAnnotations.hashCode(), other.mAnnotations.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    public static PStructDescriptorProvider<ServiceType, _Field> provider() {
        return new _Provider();
    }

    public PStructDescriptor<ServiceType, _Field> descriptor() {
        return kDescriptor;
    }

    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<ServiceType> {
        private BitSet optionals = new BitSet(5);
        private String mComment;
        private String mName;
        private String mExtend;
        private PList.Builder mMethods = new PList.ImmutableListBuilder();
        private PMap.Builder mAnnotations = new PMap.ImmutableMapBuilder();

        public _Builder() {
        }

        public _Builder(ServiceType base) {
            this();
            if (base.hasComment()) {
                this.optionals.set(0);
                this.mComment = base.mComment;
            }
            if (base.hasName()) {
                this.optionals.set(1);
                this.mName = base.mName;
            }
            if (base.hasExtend()) {
                this.optionals.set(2);
                this.mExtend = base.mExtend;
            }
            if (base.numMethods() > 0) {
                this.optionals.set(3);
                this.mMethods.addAll((Collection)base.mMethods);
            }
            if (base.numAnnotations() > 0) {
                this.optionals.set(4);
                this.mAnnotations.putAll(base.mAnnotations);
            }
        }

        public _Builder setComment(String value) {
            this.optionals.set(0);
            this.mComment = value;
            return this;
        }

        public boolean isSetComment() {
            return this.optionals.get(0);
        }

        public _Builder clearComment() {
            this.optionals.set(0, false);
            this.mComment = null;
            return this;
        }

        public _Builder setName(String value) {
            this.optionals.set(1);
            this.mName = value;
            return this;
        }

        public boolean isSetName() {
            return this.optionals.get(1);
        }

        public _Builder clearName() {
            this.optionals.set(1, false);
            this.mName = null;
            return this;
        }

        public _Builder setExtend(String value) {
            this.optionals.set(2);
            this.mExtend = value;
            return this;
        }

        public boolean isSetExtend() {
            return this.optionals.get(2);
        }

        public _Builder clearExtend() {
            this.optionals.set(2, false);
            this.mExtend = null;
            return this;
        }

        public _Builder setMethods(Collection<ServiceMethod> value) {
            this.optionals.set(3);
            this.mMethods.clear();
            this.mMethods.addAll(value);
            return this;
        }

        public _Builder addToMethods(ServiceMethod ... values) {
            this.optionals.set(3);
            for (ServiceMethod item : values) {
                this.mMethods.add((Object)item);
            }
            return this;
        }

        public boolean isSetMethods() {
            return this.optionals.get(3);
        }

        public _Builder clearMethods() {
            this.optionals.set(3, false);
            this.mMethods.clear();
            return this;
        }

        public _Builder setAnnotations(Map<String, String> value) {
            this.optionals.set(4);
            this.mAnnotations.clear();
            this.mAnnotations.putAll(value);
            return this;
        }

        public _Builder putInAnnotations(String key, String value) {
            this.optionals.set(4);
            this.mAnnotations.put((Object)key, (Object)value);
            return this;
        }

        public boolean isSetAnnotations() {
            return this.optionals.get(4);
        }

        public _Builder clearAnnotations() {
            this.optionals.set(4, false);
            this.mAnnotations.clear();
            return this;
        }

        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setComment((String)value);
                    break;
                }
                case 2: {
                    this.setName((String)value);
                    break;
                }
                case 3: {
                    this.setExtend((String)value);
                    break;
                }
                case 4: {
                    this.setMethods((List)value);
                    break;
                }
                case 5: {
                    this.setAnnotations((Map)value);
                }
            }
            return this;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 4: {
                    this.addToMethods((ServiceMethod)value);
                    break;
                }
            }
            return this;
        }

        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearComment();
                    break;
                }
                case 2: {
                    this.clearName();
                    break;
                }
                case 3: {
                    this.clearExtend();
                    break;
                }
                case 4: {
                    this.clearMethods();
                    break;
                }
                case 5: {
                    this.clearAnnotations();
                }
            }
            return this;
        }

        public boolean isValid() {
            return this.optionals.get(1);
        }

        public ServiceType build() {
            return new ServiceType(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<ServiceType> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<ServiceType, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<ServiceType, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<ServiceType, _Field> {
        public _Descriptor() {
            super("model", "ServiceType", (PMessageBuilderFactory)new _Factory(), false, false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        COMMENT(1, PRequirement.DEFAULT, "comment", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        NAME(2, PRequirement.REQUIRED, "name", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        EXTEND(3, PRequirement.DEFAULT, "extend", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        METHODS(4, PRequirement.DEFAULT, "methods", (PDescriptorProvider)PList.provider(ServiceMethod.provider()), null),
        ANNOTATIONS(5, PRequirement.DEFAULT, "annotations", (PDescriptorProvider)PMap.provider((PDescriptorProvider)PPrimitive.STRING.provider(), (PDescriptorProvider)PPrimitive.STRING.provider()), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PType getType() {
            return this.getDescriptor().getType();
        }

        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ServiceType._Field(").append(this.mKey).append(": ");
            if (this.mRequired != PRequirement.DEFAULT) {
                builder.append(this.mRequired.label).append(" ");
            }
            builder.append(this.getDescriptor().getQualifiedName(null)).append(' ').append(this.mName).append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return COMMENT;
                }
                case 2: {
                    return NAME;
                }
                case 3: {
                    return EXTEND;
                }
                case 4: {
                    return METHODS;
                }
                case 5: {
                    return ANNOTATIONS;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "comment": {
                    return COMMENT;
                }
                case "name": {
                    return NAME;
                }
                case "extend": {
                    return EXTEND;
                }
                case "methods": {
                    return METHODS;
                }
                case "annotations": {
                    return ANNOTATIONS;
                }
            }
            return null;
        }
    }
}

