/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.junit4;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.PrettySerializer;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.testing.generator.GeneratorContext;
import net.morimekta.providence.testing.junit4.SimpleGeneratorWatcher;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class GeneratorWatcher<Context extends GeneratorContext<Context>>
extends TestWatcher {
    private Serializer globalOutputSerializer;
    private List<PMessageDescriptor> globalDumpOnFailure;
    private boolean globalDumpAllOnFailure;
    private Serializer outputSerializer;
    private List<PMessageDescriptor> dumpOnFailure;
    private boolean dumpAllOnFailure;
    private Context globalContext;
    private Context context;
    private boolean started;

    public static SimpleGeneratorWatcher create() {
        return SimpleGeneratorWatcher.create();
    }

    public static <Context extends GeneratorContext<Context>> GeneratorWatcher<Context> create(Context base) {
        return new GeneratorWatcher<Context>(base);
    }

    protected GeneratorWatcher(Context globalContext) {
        this.globalOutputSerializer = this.outputSerializer = new PrettySerializer().config();
        this.dumpOnFailure = new ArrayList<PMessageDescriptor>();
        this.globalDumpOnFailure = this.dumpOnFailure;
        this.dumpAllOnFailure = false;
        this.globalDumpAllOnFailure = false;
        this.context = globalContext;
        this.globalContext = this.context;
        this.started = false;
    }

    public <M extends PMessage<M>> M generate(PMessageDescriptor<M> descriptor) {
        return (M)this.context.nextMessage(descriptor);
    }

    public GeneratorWatcher<Context> apply(Consumer<Context> consumer) {
        consumer.accept(this.context);
        return this;
    }

    public Context context() {
        return this.context;
    }

    public void dumpGeneratedMessages() throws IOException {
        for (PMessage message : this.context.getGeneratedMessages()) {
            this.outputSerializer.serialize((OutputStream)System.err, (PMessageOrBuilder)message);
            System.err.println();
        }
    }

    public void dumpGeneratedMessages(@Nonnull PMessageDescriptor descriptor) throws IOException {
        for (PMessage message : this.context.getGeneratedMessages()) {
            if (!descriptor.equals((Object)message.descriptor()) && !descriptor.equals((Object)message.descriptor().getImplementing())) continue;
            this.outputSerializer.serialize((OutputStream)System.err, (PMessageOrBuilder)message);
            System.err.println();
        }
    }

    public GeneratorWatcher<Context> setOutputSerializer(Serializer defaultSerializer) {
        if (this.started) {
            this.outputSerializer = defaultSerializer;
        } else {
            this.outputSerializer = defaultSerializer;
            this.globalOutputSerializer = defaultSerializer;
        }
        return this;
    }

    public GeneratorWatcher<Context> dumpOnFailure() {
        this.dumpAllOnFailure = true;
        if (!this.started) {
            this.globalDumpAllOnFailure = true;
        }
        return this;
    }

    public GeneratorWatcher<Context> dumpOnFailure(PMessageDescriptor descriptor) {
        this.dumpOnFailure.add(descriptor);
        return this;
    }

    protected void starting(Description description) {
        super.starting(description);
        if (!description.isEmpty() && description.getMethodName() == null) {
            throw new AssertionError((Object)"MessageGenerator instantiated as class rule: forbidden");
        }
        this.dumpOnFailure = new ArrayList<PMessageDescriptor>(this.globalDumpOnFailure);
        this.dumpAllOnFailure = this.globalDumpAllOnFailure;
        this.outputSerializer = this.globalOutputSerializer;
        this.context = this.globalContext.deepCopy();
        this.context.clearGeneratedMessages();
        this.started = true;
    }

    protected void failed(Throwable e, Description description) {
        try {
            if (this.dumpAllOnFailure) {
                this.dumpGeneratedMessages();
            } else {
                for (PMessageDescriptor descriptor : this.dumpOnFailure) {
                    this.dumpGeneratedMessages(descriptor);
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            e.addSuppressed(e1);
        }
    }

    protected void finished(Description description) {
        this.started = false;
        this.dumpOnFailure = this.globalDumpOnFailure;
        this.dumpAllOnFailure = this.globalDumpAllOnFailure;
        this.outputSerializer = this.globalOutputSerializer;
        this.context = this.globalContext;
    }
}

