/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.testing.junit4;

import io.codearte.jfairy.Fairy;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.morimekta.providence.testing.generator.GeneratorContext;
import net.morimekta.providence.testing.junit4.GeneratorWatcher;

public final class SimpleGeneratorWatcher
extends GeneratorWatcher<Context> {
    private static final Map<Locale, Fairy> fairyInstances = new ConcurrentHashMap<Locale, Fairy>();

    public static SimpleGeneratorWatcher create() {
        return new SimpleGeneratorWatcher();
    }

    public SimpleGeneratorWatcher() {
        super(new Context());
    }

    private static Fairy getFairySingleton(Locale locale) {
        return fairyInstances.computeIfAbsent(locale, l -> Fairy.create((Locale)locale));
    }

    public static class Context
    extends GeneratorContext<Context> {
        private Locale locale;
        private Fairy fairy;

        public Context() {
            this.locale = Locale.US;
            this.fairy = SimpleGeneratorWatcher.getFairySingleton(Locale.US);
        }

        public Context(Context copy) {
            super((GeneratorContext)copy);
            this.locale = copy.locale;
            this.fairy = copy.fairy;
        }

        @Nonnull
        public Context setFairy(Fairy fairy) {
            this.fairy = fairy;
            return this;
        }

        @Nonnull
        public Context setLocale(@Nonnull Locale locale) {
            this.locale = locale;
            this.fairy = SimpleGeneratorWatcher.getFairySingleton(locale);
            return this;
        }

        @Nonnull
        public Fairy getFairy() {
            return this.fairy;
        }

        @Nonnull
        public Locale getLocale() {
            return this.locale;
        }
    }
}

