/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.storage.MessageListStore;
import net.morimekta.providence.storage.dir.FileManager;
import net.morimekta.providence.streams.MessageCollectors;
import net.morimekta.providence.streams.MessageStreams;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.Unmodifiables;
import net.morimekta.util.concurrent.ReadWriteMutex;
import net.morimekta.util.concurrent.ReentrantReadWriteMutex;

public class DirectoryMessageListStore<K, M extends PMessage<M>>
implements MessageListStore<K, M>,
Closeable {
    private final ReadWriteMutex mutex;
    private final Set<K> keyset;
    private final FileManager<K> manager;
    private final Serializer serializer;
    private final PMessageDescriptor<M> descriptor;
    private final LoadingCache<K, List<M>> cache;

    public DirectoryMessageListStore(@Nonnull FileManager<K> manager, @Nonnull PMessageDescriptor<M> descriptor, @Nonnull Serializer serializer) {
        this.manager = manager;
        this.mutex = new ReentrantReadWriteMutex();
        this.keyset = new HashSet<K>(manager.initialKeySet());
        this.descriptor = descriptor;
        this.serializer = serializer;
        this.cache = Caffeine.newBuilder().build(this::read);
    }

    @Override
    public boolean containsKey(@Nonnull K key) {
        return (Boolean)this.mutex.lockForReading(() -> this.keyset.contains(key));
    }

    @Override
    @Nonnull
    public Collection<K> keys() {
        return (Collection)this.mutex.lockForReading(() -> new HashSet<K>(this.keyset));
    }

    @Override
    public int size() {
        return this.keyset.size();
    }

    @Override
    @Nonnull
    public Map<K, List<M>> getAll(@Nonnull Collection<K> keys) {
        return (Map)this.mutex.lockForReading(() -> new HashMap(this.cache.getAll((Iterable)keys)));
    }

    @Override
    public void putAll(@Nonnull Map<K, List<M>> values) {
        HashMap immutable = new HashMap();
        values.forEach((k, v) -> {
            List cfr_ignored_0 = (List)immutable.put(k, UnmodifiableList.copyOf((Collection)v));
        });
        this.mutex.lockForWriting(() -> {
            immutable.forEach(this::write);
            this.cache.putAll(immutable);
            this.keyset.addAll(immutable.keySet());
        });
    }

    @Override
    public void removeAll(Collection<K> keys) {
        this.mutex.lockForWriting(() -> {
            this.keyset.removeAll(keys);
            this.cache.invalidateAll((Iterable)keys);
            keys.forEach(this::delete);
        });
    }

    private List<M> read(K key) {
        try {
            List message = (List)MessageStreams.file((File)this.manager.getFileFor(key).toFile(), (Serializer)this.serializer, this.descriptor).collect(Unmodifiables.toList());
            this.keyset.add(key);
            return message;
        }
        catch (FileNotFoundException fnf) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    private void write(K key, List<M> message) {
        try {
            Path tmp = this.manager.tmpFileFor(key);
            Path file = this.manager.getFileFor(key);
            if (!Files.deleteIfExists(tmp)) {
                Files.createDirectories(tmp.getParent(), new FileAttribute[0]);
            }
            try {
                int i = (Integer)message.stream().collect(MessageCollectors.toPath((Path)tmp, (Serializer)this.serializer));
                this.keyset.add(key);
            }
            catch (UncheckedIOException e) {
                throw new IOException("Unable to write " + key.toString(), e.getCause());
            }
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.move(tmp, file, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    private void delete(K key) {
        try {
            Path file = this.manager.getFileFor(key);
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        this.cache.invalidateAll();
        this.keyset.clear();
    }
}

