/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.storage.MessageReadOnlyStore;
import net.morimekta.providence.storage.MessageSearcher;

public class PredicateFilterMessageStoreSearcher<Q, K, M extends PMessage<M>>
implements MessageSearcher<Q, M> {
    private final MessageReadOnlyStore<K, M> store;
    private final PredicateFilter<Q, K, M> predicate;

    public PredicateFilterMessageStoreSearcher(MessageReadOnlyStore<K, M> store, BiPredicate<M, Q> biPredicate) {
        this(store, (K key, M message, Q query) -> biPredicate.test(message, query));
    }

    public PredicateFilterMessageStoreSearcher(MessageReadOnlyStore<K, M> store, PredicateFilter<Q, K, M> predicate) {
        this.store = store;
        this.predicate = predicate;
    }

    @Override
    @Nonnull
    public List<M> search(@Nonnull Q query) {
        return this.stream(query).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public Stream<M> stream(@Nonnull Q query) {
        return this.store.getAll(this.store.keys()).entrySet().stream().filter(entry -> this.predicate.test(entry.getKey(), (PMessage)entry.getValue(), query)).map(Map.Entry::getValue);
    }

    public static interface PredicateFilter<Q, K, M extends PMessage<M>> {
        public boolean test(K var1, M var2, Q var3);
    }
}

