/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage.dir;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.morimekta.providence.storage.dir.FileManager;
import net.morimekta.util.FileUtil;

public class DefaultFileManager<K>
implements FileManager<K> {
    private static final String TMP_DIR = ".tmp";
    private final Path directory;
    private final Path tempDir;
    private final Function<Path, K> keyParser;
    private final Function<K, Path> keyBuilder;

    public DefaultFileManager(@Nonnull Path directory, @Nonnull Function<K, Path> keyBuilder, @Nonnull Function<Path, K> keyParser) {
        try {
            if (!Files.isDirectory(directory, new LinkOption[0])) {
                throw new IllegalArgumentException("Not a directory: " + directory.toString());
            }
            this.directory = FileUtil.readCanonicalPath((Path)directory);
            this.tempDir = this.directory.resolve(TMP_DIR);
            if (!Files.exists(this.tempDir, new LinkOption[0])) {
                Files.createDirectories(this.tempDir, new FileAttribute[0]);
            } else if (!Files.isDirectory(this.tempDir, new LinkOption[0])) {
                throw new IllegalStateException("File blocking temp directory: " + this.tempDir.toString());
            }
            this.keyBuilder = keyBuilder;
            this.keyParser = keyParser;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    @Override
    public Path getFileFor(@Nonnull K key) {
        Path path = this.keyBuilder.apply(key);
        return this.directory.resolve(this.validatePath(path, path));
    }

    @Override
    public Path tmpFileFor(@Nonnull K key) {
        Path path = this.keyBuilder.apply(key);
        return this.tempDir.resolve(this.validatePath(path, path));
    }

    @Override
    public Collection<K> initialKeySet() {
        try {
            HashSet set = new HashSet();
            Files.walkFileTree(this.directory, new PathFileVisitor(set));
            return set;
        }
        catch (IOException e) {
            throw new IllegalStateException("Storage directory no longer a directory.", e);
        }
    }

    private Path validatePath(Path key, Path originalKey) {
        if (key.isAbsolute()) {
            throw new IllegalArgumentException("Absolute path key not allowed: " + originalKey);
        }
        if (key.getFileName().toString().isEmpty()) {
            throw new IllegalArgumentException("Empty segment in path key: " + originalKey);
        }
        if (key.getFileName().toString().startsWith(".")) {
            throw new IllegalArgumentException("Special '.' not allowed in path segment start: " + originalKey);
        }
        if (key.getParent() != null) {
            this.validatePath(key.getParent(), originalKey);
        }
        return key;
    }

    private class PathFileVisitor
    implements FileVisitor<Path> {
        private final HashSet<K> set;

        public PathFileVisitor(HashSet<K> set) {
            this.set = set;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
            if (basicFileAttributes.isSymbolicLink() || path.getFileName().startsWith(".")) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
            if (basicFileAttributes.isSymbolicLink()) {
                return FileVisitResult.CONTINUE;
            }
            this.set.add(DefaultFileManager.this.keyParser.apply(DefaultFileManager.this.directory.relativize(path)));
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException e) {
            return FileVisitResult.TERMINATE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException e) {
            return FileVisitResult.CONTINUE;
        }
    }
}

