/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.storage.MessageListStore;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.concurrent.ReadWriteMutex;
import net.morimekta.util.concurrent.ReentrantReadWriteMutex;

public class InMemoryMessageListStore<K, M extends PMessage<M>>
implements MessageListStore<K, M> {
    private final Map<K, List<M>> map = new HashMap<K, List<M>>();
    private final ReadWriteMutex mutex = new ReentrantReadWriteMutex();

    @Override
    @Nonnull
    public Map<K, List<M>> getAll(@Nonnull Collection<K> keys) {
        return (Map)this.mutex.lockForReading(() -> {
            HashMap out = new HashMap();
            for (Object key : keys) {
                if (!this.map.containsKey(key)) continue;
                out.put(key, this.map.get(key));
            }
            return out;
        });
    }

    @Override
    public boolean containsKey(@Nonnull K key) {
        return (Boolean)this.mutex.lockForReading(() -> this.map.containsKey(key));
    }

    @Override
    @Nonnull
    public Collection<K> keys() {
        return (Collection)this.mutex.lockForReading(() -> new HashSet<K>(this.map.keySet()));
    }

    @Override
    public int size() {
        return (Integer)this.mutex.lockForReading(this.map::size);
    }

    @Override
    public void putAll(@Nonnull Map<K, List<M>> values) {
        this.mutex.lockForWriting(() -> {
            for (Map.Entry entry : values.entrySet()) {
                this.map.put(entry.getKey(), (List<M>)UnmodifiableList.copyOf((Collection)((Collection)entry.getValue())));
            }
        });
    }

    @Override
    public void removeAll(Collection<K> keys) {
        this.mutex.lockForWriting(() -> this.map.keySet().removeAll(keys));
    }
}

