/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.storage.MessageListStore;
import net.morimekta.providence.storage.dir.FileManager;
import net.morimekta.providence.streams.MessageCollectors;
import net.morimekta.providence.streams.MessageStreams;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.concurrent.ReadWriteMutex;
import net.morimekta.util.concurrent.ReentrantReadWriteMutex;

public class DirectoryMessageListStore<K, M extends PMessage<M>>
implements MessageListStore<K, M>,
Closeable {
    private final ReadWriteMutex mutex;
    private final Set<K> keyset;
    private final FileManager<K> manager;
    private final Serializer serializer;
    private final PMessageDescriptor<M> descriptor;
    private final Cache<K, List<M>> cache;

    public DirectoryMessageListStore(@Nonnull FileManager<K> manager, @Nonnull PMessageDescriptor<M> descriptor, @Nonnull Serializer serializer) {
        this.manager = manager;
        this.mutex = new ReentrantReadWriteMutex();
        this.keyset = new HashSet<K>(manager.initialKeySet());
        this.descriptor = descriptor;
        this.serializer = serializer;
        this.cache = CacheBuilder.newBuilder().build();
    }

    @Override
    public boolean containsKey(@Nonnull K key) {
        return (Boolean)this.mutex.lockForReading(() -> this.keyset.contains(key));
    }

    @Override
    @Nonnull
    public Collection<K> keys() {
        return (Collection)this.mutex.lockForReading(() -> new HashSet<K>(this.keyset));
    }

    @Override
    public int size() {
        return this.keyset.size();
    }

    @Override
    @Nonnull
    public Map<K, List<M>> getAll(@Nonnull Collection<K> keys) {
        return (Map)this.mutex.lockForReading(() -> {
            HashMap out = new HashMap();
            TreeSet tmp = new TreeSet(keys);
            tmp.retainAll(this.keyset);
            for (Object key : tmp) {
                try {
                    out.put(key, (List)this.cache.get(key, () -> this.read(key)));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Unable to read " + key.toString(), e);
                }
            }
            return out;
        });
    }

    @Override
    public void putAll(@Nonnull Map<K, List<M>> values) {
        this.mutex.lockForWriting(() -> values.forEach((key, value) -> {
            try {
                value = UnmodifiableList.copyOf((Collection)value);
                this.write((K)key, (List<M>)value);
                this.cache.put(key, value);
                this.keyset.add(key);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
        }));
    }

    @Override
    public void removeAll(Collection<K> keys) {
        this.mutex.lockForWriting(() -> {
            for (Object key : keys) {
                Path file = this.manager.getFileFor(key);
                if (!Files.exists(file, new LinkOption[0])) continue;
                try {
                    this.cache.get(key, () -> this.read(key));
                }
                catch (ExecutionException e) {
                    new ArrayList();
                }
                finally {
                    try {
                        Files.deleteIfExists(file);
                    }
                    catch (IOException iOException) {}
                }
                this.cache.invalidate(key);
                this.keyset.remove(key);
            }
        });
    }

    private List<M> read(K key) throws IOException {
        try {
            return MessageStreams.file((File)this.manager.getFileFor(key).toFile(), (Serializer)this.serializer, this.descriptor).collect(Collectors.toList());
        }
        catch (UncheckedIOException e) {
            throw new IOException("Unable to read " + key.toString(), e.getCause());
        }
    }

    private void write(K key, List<M> message) throws IOException {
        Path tmp = this.manager.tmpFileFor(key);
        Path file = this.manager.getFileFor(key);
        if (!Files.deleteIfExists(tmp)) {
            Files.createDirectories(tmp.getParent(), new FileAttribute[0]);
        }
        try {
            message.stream().collect(MessageCollectors.toPath((Path)tmp, (Serializer)this.serializer));
        }
        catch (UncheckedIOException e) {
            throw new IOException("Unable to write " + key.toString(), e.getCause());
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Files.move(tmp, file, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
    }

    @Override
    public void close() {
        this.cache.invalidateAll();
        this.keyset.clear();
    }
}

