/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageOrBuilder;

public class MessageStoreUtils {
    public static <M extends PMessage<M>, V extends PMessageOrBuilder<M>> List<M> toMessageAll(Collection<V> builders) {
        if (builders == null) {
            return null;
        }
        return builders.stream().map(PMessageOrBuilder::toMessage).collect(Collectors.toList());
    }

    public static <M extends PMessage<M>, V extends PMessageOrBuilder<M>, B extends PMessageBuilder<M>> List<B> toBuilderAll(Collection<V> messages) {
        if (messages == null) {
            return null;
        }
        return messages.stream().map(mob -> mob.toBuilder()).collect(Collectors.toList());
    }

    public static <K, M extends PMessage<M>, V extends PMessageOrBuilder<M>, B extends PMessageBuilder<M>> Map<K, B> toBuilderValues(Map<K, V> messages) {
        if (messages == null) {
            return null;
        }
        return messages.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PMessageOrBuilder)e.getValue()).toBuilder()));
    }

    public static <K, M extends PMessage<M>, V extends PMessageOrBuilder<M>> Map<K, M> toMessageValues(Map<K, V> messages) {
        if (messages == null) {
            return null;
        }
        return messages.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PMessageOrBuilder)e.getValue()).toMessage()));
    }

    public static <M extends PMessage<M>> M toMessageIfNotNull(PMessageOrBuilder<M> mob) {
        if (mob == null) {
            return null;
        }
        return (M)mob.toMessage();
    }

    public static <M extends PMessage<M>, B extends PMessageBuilder<M>> B toBuilderIfNonNull(PMessageOrBuilder<M> mob) {
        if (mob == null) {
            return null;
        }
        return (B)mob.toBuilder();
    }
}

