/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.storage.MessageStore;
import net.morimekta.util.concurrent.ReadWriteMutex;
import net.morimekta.util.concurrent.ReentrantReadWriteMutex;

public class InMemoryMessageStore<K, M extends PMessage<M>, F extends PField>
implements MessageStore<K, M> {
    private final Map<K, M> map = new HashMap<K, M>();
    private final ReadWriteMutex mutex = new ReentrantReadWriteMutex();

    @Override
    @Nonnull
    public Map<K, M> getAll(@Nonnull Collection<K> keys) {
        return (Map)this.mutex.lockForReading(() -> {
            HashMap out = new HashMap();
            for (Object key : keys) {
                if (!this.map.containsKey(key)) continue;
                out.put(key, (PMessage)this.map.get(key));
            }
            return out;
        });
    }

    @Override
    public boolean containsKey(@Nonnull K key) {
        return (Boolean)this.mutex.lockForReading(() -> this.map.containsKey(key));
    }

    @Override
    @Nonnull
    public Collection<K> keys() {
        return (Collection)this.mutex.lockForReading(() -> new HashSet<K>(this.map.keySet()));
    }

    @Override
    public int size() {
        return (Integer)this.mutex.lockForReading(this.map::size);
    }

    @Override
    public void putAll(@Nonnull Map<K, M> values) {
        this.mutex.lockForWriting(() -> this.map.putAll(values));
    }

    @Override
    public void removeAll(Collection<K> keys) {
        this.mutex.lockForWriting(() -> this.map.keySet().removeAll(keys));
    }
}

