/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.storage.MessageListReadOnlyStore;
import net.morimekta.providence.storage.MessageStoreUtils;
import net.morimekta.providence.storage.ReadWriteStore;

public interface MessageListStore<K, M extends PMessage<M, F>, F extends PField>
extends MessageListReadOnlyStore<K, M, F>,
ReadWriteStore<K, List<M>> {
    @Nullable
    default public <B extends PMessageBuilder<M, F>> List<B> putBuilders(@Nonnull K key, @Nonnull List<B> builders) {
        return MessageStoreUtils.mutateAll(this.put(key, MessageStoreUtils.buildAll(builders)));
    }

    @Nonnull
    default public <B extends PMessageBuilder<M, F>> Map<K, List<B>> putAllBuilders(@Nonnull Map<K, List<B>> builders) {
        HashMap instances = new HashMap();
        builders.forEach((k, bList) -> instances.put(k, MessageStoreUtils.buildAll(bList)));
        Map<Object, List> replaced = this.putAll(instances);
        HashMap result = new HashMap();
        replaced.forEach((k, list) -> result.put(k, MessageStoreUtils.mutateAll(list)));
        return result;
    }
}

