/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.storage.MessageReadOnlyStore;
import net.morimekta.providence.storage.MessageSearcher;

public class PredicateFilterMessageStoreSearcher<Q, K, M extends PMessage<M, F>, F extends PField>
implements MessageSearcher<Q, M, F> {
    private final MessageReadOnlyStore<K, M, F> store;
    private final PredicateFilter<Q, K, M, F> predicate;

    public PredicateFilterMessageStoreSearcher(MessageReadOnlyStore<K, M, F> store, PredicateFilter<Q, K, M, F> predicate) {
        this.store = store;
        this.predicate = predicate;
    }

    @Override
    @Nonnull
    public List<M> search(@Nonnull Q query) {
        return this.stream(query).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public Stream<M> stream(@Nonnull Q query) {
        return this.store.getAll(this.store.keys()).entrySet().stream().filter(entry -> this.predicate.test(entry.getKey(), (PMessage)entry.getValue(), query)).map(Map.Entry::getValue);
    }

    public static interface PredicateFilter<Q, K, M extends PMessage<M, F>, F extends PField> {
        public boolean test(K var1, M var2, Q var3);
    }
}

